/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.functions;

import java.util.Collection;
import org.hcjf.layers.query.functions.BaseQueryFunctionLayer;
import org.hcjf.layers.query.functions.QueryFunctionLayerInterface;
import org.hcjf.properties.SystemProperties;
import org.hcjf.utils.Strings;

public class StringQueryFunctionLayer
extends BaseQueryFunctionLayer
implements QueryFunctionLayerInterface {
    private static final String TRIM = "trim";
    private static final String LENGTH = "length";
    private static final String SPLIT = "split";
    private static final String SPLIT_BY_LENGTH = "splitByLength";
    private static final String CONCAT = "concat";
    private static final String STRING_JOIN = "stringJoin";
    private static final String TO_UPPER_CASE = "toUpperCase";
    private static final String TO_LOWER_CASE = "toLowerCase";
    private static final String TO_STRING = "toString";
    private static final String HEX_TO_BYTES = "hexToBytes";
    private static final String BYTES_TO_HEX = "bytesToHex";
    private static final String REPLACE = "replace";
    private static final String SUB_STRING = "subString";
    private static final String INDEX_OF = "indexOf";

    public StringQueryFunctionLayer() {
        super(SystemProperties.get("hcjf.query.function.string.name"));
        this.addFunctionName(TRIM);
        this.addFunctionName(LENGTH);
        this.addFunctionName(SPLIT);
        this.addFunctionName(SPLIT_BY_LENGTH);
        this.addFunctionName(CONCAT);
        this.addFunctionName(STRING_JOIN);
        this.addFunctionName(TO_UPPER_CASE);
        this.addFunctionName(TO_LOWER_CASE);
        this.addFunctionName(TO_STRING);
        this.addFunctionName(HEX_TO_BYTES);
        this.addFunctionName(BYTES_TO_HEX);
        this.addFunctionName(REPLACE);
        this.addFunctionName(SUB_STRING);
        this.addFunctionName(INDEX_OF);
    }

    @Override
    public Object evaluate(String functionName, Object ... parameters) {
        Object result = null;
        switch (functionName) {
            case "trim": {
                result = ((String)this.getParameter(0, parameters)).trim();
                break;
            }
            case "length": {
                result = ((String)this.getParameter(0, parameters)).length();
                break;
            }
            case "split": {
                result = ((String)this.getParameter(0, parameters)).split((String)this.getParameter(1, parameters));
                break;
            }
            case "splitByLength": {
                result = Strings.splitByLength((String)this.getParameter(0, parameters), ((Number)this.getParameter(1, parameters)).intValue());
                break;
            }
            case "toUpperCase": {
                result = ((String)this.getParameter(0, parameters)).toUpperCase();
                break;
            }
            case "toLowerCase": {
                result = ((String)this.getParameter(0, parameters)).toLowerCase();
                break;
            }
            case "toString": {
                result = this.getParameter(0, parameters).toString();
                break;
            }
            case "hexToBytes": {
                result = Strings.hexToBytes((String)this.getParameter(0, parameters));
                break;
            }
            case "bytesToHex": {
                result = Strings.bytesToHex((byte[])this.getParameter(0, parameters));
                break;
            }
            case "replace": {
                String source = (String)this.getParameter(0, parameters);
                String target = (String)this.getParameter(1, parameters);
                String replacement = (String)this.getParameter(2, parameters);
                result = source.replace(target, replacement);
                break;
            }
            case "concat": {
                StringBuilder builder = new StringBuilder();
                for (Object parameter : parameters) {
                    if (parameter instanceof Collection) {
                        for (Object collectionParameter : (Collection)parameter) {
                            builder.append(collectionParameter);
                        }
                        continue;
                    }
                    builder.append(parameter);
                }
                result = builder.toString();
                break;
            }
            case "stringJoin": {
                Strings.Builder builder = new Strings.Builder();
                for (int i = 1; i < parameters.length; ++i) {
                    if (parameters[i] instanceof Collection) {
                        for (Object collectionParameter : (Collection)parameters[i]) {
                            builder.append(collectionParameter, (String[])this.getParameter(0, parameters));
                        }
                        continue;
                    }
                    builder.append(parameters[i], (String)this.getParameter(0, parameters));
                }
                result = builder.toString();
                break;
            }
            case "subString": {
                String value = (String)this.getParameter(0, parameters);
                Number startIndex = (Number)this.getParameter(1, parameters);
                if (parameters.length == 3) {
                    Number endIndex = (Number)this.getParameter(2, parameters);
                    result = value.substring(startIndex.intValue(), endIndex.intValue());
                    break;
                }
                result = value.substring(startIndex.intValue());
                break;
            }
            case "indexOf": {
                String value = (String)this.getParameter(0, parameters);
                String pattern = (String)this.getParameter(1, parameters);
                Integer fromIndex = 0;
                if (parameters.length == 3) {
                    fromIndex = ((Number)this.getParameter(2, parameters)).intValue();
                }
                result = value.indexOf(pattern, (int)fromIndex);
                break;
            }
        }
        return result;
    }
}

