/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.scripting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.Proxy;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.hcjf.layers.Layer;
import org.hcjf.layers.scripting.CodeEvaluator;
import org.hcjf.layers.scripting.ExecutionResult;
import org.hcjf.properties.SystemProperties;
import org.hcjf.utils.Strings;

public class JsCodeEvaluator
extends Layer
implements CodeEvaluator {
    private static final String METHOD_DEFINITION = "(%s) => {%s}";
    private static final String GRAALVM_JS = "js";
    private final Context context = Context.newBuilder((String[])new String[]{"js"}).build();

    @Override
    public String getImplName() {
        return SystemProperties.get("hcjf.code.evaluator.js.impl.name");
    }

    @Override
    public ExecutionResult evaluate(String script, Map<String, Object> parameters) {
        Strings.Builder parametersBuilder = new Strings.Builder();
        ArrayList<Object> values = new ArrayList<Object>();
        for (String parameterName : parameters.keySet()) {
            parametersBuilder.append(parameterName, ",");
            values.add(this.getParameterInstance(parameterName, parameters));
        }
        String methodDefinition = String.format(METHOD_DEFINITION, parametersBuilder, script);
        Value value = this.context.eval(GRAALVM_JS, (CharSequence)methodDefinition);
        ExecutionResult executionResult = new ExecutionResult(ExecutionResult.State.SUCCESS, Map.of(), parameters, this.getResultInstance(value.execute(values.toArray())));
        return executionResult;
    }

    public Object getParameterInstance(String parameterName, Map<String, Object> parameters) {
        Object result = parameters.get(parameterName);
        if (result instanceof Map) {
            result = this.getProxyObjectFromMap((Map)result);
        } else if (result instanceof Collection) {
            result = this.getProxyArrayFromCollection((Collection)result);
        }
        return result;
    }

    public ProxyObject getProxyObjectFromMap(Map<String, Object> map) {
        HashMap<String, Object> mapCopy = new HashMap<String, Object>();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof Map) {
                mapCopy.put(key, this.getProxyObjectFromMap((Map)value));
                continue;
            }
            if (value instanceof Collection) {
                mapCopy.put(key, this.getProxyArrayFromCollection((Collection)value));
                continue;
            }
            mapCopy.put(key, value);
        }
        return ProxyObject.fromMap(mapCopy);
    }

    public ProxyArray getProxyArrayFromCollection(Collection<Object> collection) {
        ArrayList<Object> collectionCopy = new ArrayList<Object>();
        for (Object value : collection) {
            if (value instanceof Map) {
                collectionCopy.add(this.getProxyObjectFromMap((Map)value));
                continue;
            }
            if (value instanceof Collection) {
                collectionCopy.add(this.getProxyArrayFromCollection((Collection)value));
                continue;
            }
            collectionCopy.add(value);
        }
        return ProxyArray.fromList(collectionCopy);
    }

    public Object getResultInstance(Object scriptResult) {
        Object result = scriptResult;
        if (scriptResult instanceof Value) {
            result = this.getResultInstance((Value)result);
        } else if (scriptResult instanceof ProxyObject) {
            result = this.getResultFromProxyObject((ProxyObject)result);
        } else if (scriptResult instanceof ProxyArray) {
            result = this.getResultFromProxyArray((ProxyArray)result);
        }
        return result;
    }

    public Object getResultFromProxyObject(ProxyObject proxyObject) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ProxyArray list = (ProxyArray)proxyObject.getMemberKeys();
        for (long i = 0L; i < list.getSize(); ++i) {
            String key = (String)list.get(i);
            resultMap.put(key, this.getResultInstance(proxyObject.getMember(key)));
        }
        return resultMap;
    }

    public Object getResultFromProxyArray(ProxyArray proxyArray) {
        ArrayList<Object> resultArray = new ArrayList<Object>();
        for (long i = 0L; i < proxyArray.getSize(); ++i) {
            resultArray.add(this.getResultInstance(proxyArray.get(i)));
        }
        return resultArray;
    }

    public Object getResultInstance(Value scriptResult) {
        Cloneable result = null;
        if (scriptResult.isBoolean()) {
            result = scriptResult.asBoolean();
        } else if (scriptResult.isDate()) {
            result = scriptResult.asDate();
        } else if (scriptResult.isString()) {
            result = scriptResult.asString();
        } else if (scriptResult.isNumber()) {
            result = scriptResult.asDouble();
        } else if (scriptResult.isProxyObject()) {
            Proxy proxy = scriptResult.asProxyObject();
            if (proxy instanceof ProxyObject) {
                result = this.getResultFromProxyObject((ProxyObject)proxy);
            } else if (proxy instanceof ProxyArray) {
                result = this.getResultFromProxyArray((ProxyArray)proxy);
            }
        } else if (scriptResult.hasArrayElements()) {
            ArrayList<Object> resultCollection = new ArrayList<Object>();
            for (long i = 0L; i < scriptResult.getArraySize(); ++i) {
                resultCollection.add(this.getResultInstance(scriptResult.getArrayElement(i)));
            }
            result = resultCollection;
        } else {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            for (String key : scriptResult.getMemberKeys()) {
                resultMap.put(key, this.getResultInstance(scriptResult.getMember(key)));
            }
            result = resultMap;
        }
        return result;
    }
}

