/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.service;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.errors.HCJFServiceTimeoutException;
import org.hcjf.log.Log;
import org.hcjf.log.debug.Agent;
import org.hcjf.log.debug.Agents;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.ServiceConsumer;
import org.hcjf.service.ServiceSession;
import org.hcjf.service.ServiceThread;

public abstract class Service<C extends ServiceConsumer> {
    protected static final String SERVICE_LOG_TAG = "SERVICE";
    private static final String MAIN_EXECUTOR_NAME = "Main Thread Pool %s";
    private final String serviceName;
    private final ThreadFactory serviceThreadFactory;
    private final ThreadPoolExecutor serviceExecutor;
    private final Map<String, ThreadPoolExecutor> registeredExecutors;
    private final Integer priority;

    protected Service(String serviceName, Integer priority) {
        if (serviceName == null) {
            throw new NullPointerException("Service name can't be null");
        }
        if (SystemServices.instance.exist(serviceName)) {
            throw new IllegalArgumentException("The service name (" + serviceName + ") is already register");
        }
        this.serviceName = serviceName;
        this.priority = priority;
        this.serviceThreadFactory = this.createThreadFactory();
        this.serviceExecutor = (ThreadPoolExecutor)Executors.newCachedThreadPool(this.serviceThreadFactory);
        this.serviceExecutor.setCorePoolSize(SystemProperties.getInteger("hcjf.service.thread.pool.core.size"));
        this.serviceExecutor.setMaximumPoolSize(SystemProperties.getInteger("hcjf.service.thread.pool.max.size"));
        this.serviceExecutor.setKeepAliveTime(SystemProperties.getLong("hcjf.service.thread.pool.keep.alive.time"), TimeUnit.SECONDS);
        this.registeredExecutors = new HashMap<String, ThreadPoolExecutor>();
        this.init();
        if (!this.getClass().equals(Log.class)) {
            SystemServices.instance.register(this);
        } else {
            SystemServices.instance.setLog((Log)this);
        }
        Agents.register(new ThreadPoolAgent(String.format(MAIN_EXECUTOR_NAME, serviceName), this.serviceExecutor));
    }

    protected ThreadFactory createThreadFactory() {
        return r -> new ServiceThread(this, r, this.getServiceName() + UUID.randomUUID());
    }

    private ThreadPoolExecutor getServiceExecutor() {
        return this.serviceExecutor;
    }

    protected final <R> Future<R> fork(Callable<R> callable) {
        return this.fork(callable, null, this.getServiceExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerExecutor(String executorName, ThreadPoolExecutor executor) {
        if (!executor.equals(this.serviceExecutor)) {
            if (executorName == null) {
                throw new NullPointerException("Executor name is null");
            }
            Service service = this;
            synchronized (service) {
                if (!this.registeredExecutors.containsKey(executorName)) {
                    this.registeredExecutors.put(executorName, executor);
                    Agents.register(new ThreadPoolAgent(executorName, executor));
                }
            }
        }
    }

    private ServiceSession getSession() {
        ServiceSession session = ServiceSession.getGuestSession();
        if (Thread.currentThread() instanceof ServiceThread) {
            session = ((ServiceThread)Thread.currentThread()).getSession();
        }
        return session;
    }

    private Map<String, Object> getInvokerProperties() {
        Map<String, Object> result = null;
        if (Thread.currentThread() instanceof ServiceThread) {
            result = this.getSession().getProperties();
        }
        return result;
    }

    protected final <R> Future<R> fork(Callable<R> callable, String executorName, ThreadPoolExecutor executor) {
        this.registerExecutor(executorName, executor);
        return executor.submit(new CallableWrapper<R>(callable, this.getSession(), this.getInvokerProperties()));
    }

    protected final Future fork(Runnable runnable) {
        return this.fork(runnable, null, this.getServiceExecutor());
    }

    protected final Future fork(Runnable runnable, String executorName, ThreadPoolExecutor executor) {
        this.registerExecutor(executorName, executor);
        return executor.submit(new RunnableWrapper(runnable, this.getSession(), this.getInvokerProperties()));
    }

    public final String getServiceName() {
        return this.serviceName;
    }

    public final Integer getPriority() {
        return this.priority;
    }

    protected void init() {
    }

    protected void shutdown(ShutdownStage stage) {
    }

    protected void shutdownExecutor(ThreadPoolExecutor executor) {
        long shutdownTimeout = SystemProperties.getLong("hcjf.service.shutdown.time.out");
        executor.shutdown();
        long startTime = System.currentTimeMillis();
        while (!executor.isTerminated() && System.currentTimeMillis() - startTime < shutdownTimeout) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (!executor.isTerminated()) {
            executor.shutdownNow();
            startTime = System.currentTimeMillis();
            while (!executor.isTerminated() && System.currentTimeMillis() - startTime < shutdownTimeout) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    public abstract void registerConsumer(C var1);

    public abstract void unregisterConsumer(C var1);

    public static final void systemShutdown() {
        SystemServices.instance.shutdown();
    }

    public static final void run(Runnable runnable, ServiceSession session) {
        Service.run(runnable, session, false, 0L);
    }

    public static final void run(Runnable runnable, ServiceSession session, boolean waitFor, long timeout) {
        RunnableWrapper serviceRunnable = new RunnableWrapper(runnable, session.getClone());
        Future<?> future = SystemServices.instance.serviceExecutor.submit(serviceRunnable);
        if (waitFor) {
            try {
                if (timeout > 0L) {
                    future.get(timeout, TimeUnit.MILLISECONDS);
                } else {
                    future.get();
                }
            }
            catch (TimeoutException ex) {
                future.cancel(true);
                throw new HCJFServiceTimeoutException("Service run timout", (Throwable)ex, new Object[0]);
            }
            catch (Exception ex) {
                throw new HCJFRuntimeException("Service run fail", (Throwable)ex, new Object[0]);
            }
        }
    }

    public static final <O> O call(Callable<O> callable, ServiceSession serviceSession) {
        return Service.call(callable, serviceSession, 0L);
    }

    public static final <O> O call(Callable<O> callable, ServiceSession serviceSession, long timeout) {
        O result;
        CallableWrapper<O> callableWrapper = new CallableWrapper<O>(callable, serviceSession.getClone());
        Future<O> future = SystemServices.instance.serviceExecutor.submit(callableWrapper);
        try {
            result = timeout > 0L ? future.get(timeout, TimeUnit.MILLISECONDS) : future.get();
        }
        catch (TimeoutException ex) {
            future.cancel(true);
            throw new HCJFServiceTimeoutException("Service call timout", (Throwable)ex, new Object[0]);
        }
        catch (Exception ex) {
            throw new HCJFRuntimeException("Service call fail", (Throwable)ex, new Object[0]);
        }
        return result;
    }

    public static class ThreadPoolAgent
    extends Agent
    implements ThreadPoolAgentMBean {
        private static final String PACKAGE_NAME = Service.class.getPackageName();
        private final ThreadPoolExecutor threadPoolExecutor;

        public ThreadPoolAgent(String name, ThreadPoolExecutor threadPoolExecutor) {
            super(name, PACKAGE_NAME);
            this.threadPoolExecutor = threadPoolExecutor;
        }

        @Override
        public long getActiveCount() {
            return this.threadPoolExecutor.getActiveCount();
        }

        @Override
        public long getCompletedTaskCount() {
            return this.threadPoolExecutor.getCompletedTaskCount();
        }

        @Override
        public long getTaskCount() {
            return this.threadPoolExecutor.getTaskCount();
        }

        @Override
        public int getCorePoolSize() {
            return this.threadPoolExecutor.getCorePoolSize();
        }

        @Override
        public int getMaximumPoolSize() {
            return this.threadPoolExecutor.getMaximumPoolSize();
        }

        @Override
        public int getLargestPoolSize() {
            return this.threadPoolExecutor.getLargestPoolSize();
        }

        @Override
        public int getPoolSize() {
            return this.threadPoolExecutor.getPoolSize();
        }
    }

    public static interface ThreadPoolAgentMBean {
        public long getActiveCount();

        public long getCompletedTaskCount();

        public long getTaskCount();

        public int getCorePoolSize();

        public int getMaximumPoolSize();

        public int getLargestPoolSize();

        public int getPoolSize();
    }

    private static class CallableWrapper<O>
    implements Callable<O> {
        private final Callable<O> callable;
        private final ServiceSession session;
        private final Map<String, Object> invokerProperties;

        public CallableWrapper(Callable<O> callable, ServiceSession session) {
            this(callable, session, new HashMap<String, Object>());
        }

        public CallableWrapper(Callable<O> callable, ServiceSession session, Map<String, Object> invokerProperties) {
            this.callable = callable;
            this.invokerProperties = invokerProperties;
            this.session = session != null ? session : ServiceSession.getGuestSession();
        }

        @Override
        public O call() throws Exception {
            if (!(Thread.currentThread() instanceof ServiceThread)) {
                throw new IllegalArgumentException("All the service executions must be over ServiceThread implementation");
            }
            try {
                ((ServiceThread)Thread.currentThread()).setSession(this.session);
                if (this.invokerProperties != null) {
                    this.session.putAll(this.invokerProperties);
                }
                O o = this.callable.call();
                return o;
            }
            finally {
                ((ServiceThread)Thread.currentThread()).setSession(null);
            }
        }
    }

    private static class RunnableWrapper
    implements Runnable {
        private final Runnable runnable;
        private final ServiceSession session;
        private final Map<String, Object> invokerProperties;
        private final long creationTime;

        public RunnableWrapper(Runnable runnable, ServiceSession session) {
            this(runnable, session, new HashMap<String, Object>());
        }

        public RunnableWrapper(Runnable runnable, ServiceSession session, Map<String, Object> invokerProperties) {
            this.runnable = runnable;
            this.invokerProperties = invokerProperties;
            this.creationTime = System.currentTimeMillis();
            this.session = session != null ? session : ServiceSession.getGuestSession();
        }

        @Override
        public void run() {
            if (!(Thread.currentThread() instanceof ServiceThread)) {
                throw new IllegalArgumentException("All the service executions must be over ServiceThread implementation");
            }
            try {
                ((ServiceThread)Thread.currentThread()).setSession(this.session);
                if (this.invokerProperties != null) {
                    this.session.putAll(this.invokerProperties);
                }
                this.runnable.run();
            }
            finally {
                ((ServiceThread)Thread.currentThread()).setSession(null);
            }
        }
    }

    public static class RunnableWrapperComparator
    implements Comparator<Runnable> {
        @Override
        public int compare(Runnable o1, Runnable o2) {
            int result = (int)(((RunnableWrapper)o1).creationTime - ((RunnableWrapper)o2).creationTime) * -1;
            if (result == 0) {
                result = o1.hashCode() - o2.hashCode();
            }
            return result;
        }
    }

    protected static enum ShutdownStage {
        START,
        END;

    }

    public static final class StaticServiceThread
    extends ServiceThread {
        private StaticServiceThread(Runnable target, String name) {
            super(target, name);
        }
    }

    private static class SystemServices {
        private static final SystemServices instance = new SystemServices();
        private final ThreadPoolExecutor serviceExecutor = (ThreadPoolExecutor)Executors.newCachedThreadPool(runnable -> new StaticServiceThread(runnable, SystemProperties.get("hcjf.service.static.thread.name")));
        private final Map<String, Service> services;
        private Log log;

        private SystemServices() {
            this.serviceExecutor.setCorePoolSize(SystemProperties.getInteger("hcjf.service.static.thread.pool.core.size"));
            this.serviceExecutor.setMaximumPoolSize(SystemProperties.getInteger("hcjf.service.static.thread.pool.max.size"));
            this.serviceExecutor.setKeepAliveTime(SystemProperties.getLong("hcjf.service.static.thread.pool.keep.alive.time"), TimeUnit.SECONDS);
            this.services = new HashMap<String, Service>();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.shutdown()));
        }

        public void setLog(Log log) {
            this.log = log;
        }

        private void register(Service service) {
            this.services.put(service.getServiceName(), service);
            Log.i(Service.SERVICE_LOG_TAG, "Service registered: %s", service.getServiceName());
        }

        private boolean exist(String serviceName) {
            return this.services.containsKey(serviceName);
        }

        private void shutdown() {
            TreeSet<Service> sortedServices = new TreeSet<Service>((s1, s2) -> {
                int result = s1.getPriority() - s2.getPriority();
                if (result == 0) {
                    result = s1.hashCode() - s2.hashCode();
                }
                return result * -1;
            });
            int errors = 0;
            Log.i(Service.SERVICE_LOG_TAG, "Starting shutdown", new Object[0]);
            sortedServices.addAll(this.services.values());
            for (Service service : sortedServices) {
                Log.i(Service.SERVICE_LOG_TAG, "Starting service shutdown (%s)", service.getServiceName());
                Log.i(Service.SERVICE_LOG_TAG, "Starting service shutdown custom process", new Object[0]);
                try {
                    service.shutdown(ShutdownStage.START);
                    Log.i(Service.SERVICE_LOG_TAG, "Start stage: Shutdown custom process done", new Object[0]);
                }
                catch (Exception ex) {
                    Log.i(Service.SERVICE_LOG_TAG, "Start stage: Shutdown custom process done with errors", ex);
                    ++errors;
                }
                Log.i(Service.SERVICE_LOG_TAG, "Ending custom executors", new Object[0]);
                service.registeredExecutors.values().forEach(service::shutdownExecutor);
                Log.i(Service.SERVICE_LOG_TAG, "Custom executors finalized", new Object[0]);
                try {
                    service.shutdown(ShutdownStage.END);
                    Log.i(Service.SERVICE_LOG_TAG, "End stage: Shutdown custom process done", new Object[0]);
                }
                catch (Exception ex) {
                    Log.i(Service.SERVICE_LOG_TAG, "End stage: Shutdown custom process done with errors", ex);
                    ++errors;
                }
                Log.i(Service.SERVICE_LOG_TAG, "Ending main service threadPoolExecutor", new Object[0]);
                service.shutdownExecutor(this.serviceExecutor);
                Log.i(Service.SERVICE_LOG_TAG, "Main service threadPoolExecutor finalized", new Object[0]);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                ((Service)this.log).shutdown(ShutdownStage.START);
                this.log.shutdownExecutor(this.serviceExecutor);
                ((Service)this.log).shutdown(ShutdownStage.END);
            }
            catch (Exception ex) {
                ++errors;
            }
            System.out.println("Shutdown completed! See you");
            Runtime.getRuntime().halt(errors);
        }
    }
}

