/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.service;

import com.sun.management.ThreadMXBean;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.Service;
import org.hcjf.service.ServiceSession;
import org.hcjf.service.ServiceThreadGroup;

public class ServiceThread
extends Thread {
    private static final String NAME = "ServiceThread";
    private final Service service;
    private ServiceSession session;
    private Long initialAllocatedMemory;
    private Long maxAllocatedMemory;
    private Long initialTime;
    private Long maxExecutionTime;

    public ServiceThread(Service service, Runnable target, String name) {
        super(ServiceThreadGroup.getInstance(), target, name);
        this.service = service;
    }

    public ServiceThread(Runnable target, String name) {
        this((Service)null, target, name);
    }

    public final Class<? extends Service> getServiceClass() {
        return this.service == null ? null : this.service.getClass();
    }

    public final void putLayer(ServiceSession.LayerStackElement element) {
        this.getSession().putLayer(element);
    }

    public final void removeLayer() {
        this.getSession().removeLayer();
    }

    public Collection<ServiceSession.LayerStackElement> getLayerStack() {
        return this.getSession().getLayerStack();
    }

    public final ServiceSession getSession() {
        return this.session;
    }

    public final Long getMaxAllocatedMemory() {
        return this.maxAllocatedMemory;
    }

    private void setMaxAllocatedMemory(Long maxAllocatedMemory) {
        this.maxAllocatedMemory = maxAllocatedMemory;
    }

    public final Long getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    private void setMaxExecutionTime(Long maxExecutionTime) {
        this.maxExecutionTime = maxExecutionTime;
    }

    public Long getInitialAllocatedMemory() {
        return this.initialAllocatedMemory;
    }

    private void setInitialAllocatedMemory(Long initialAllocatedMemory) {
        this.initialAllocatedMemory = initialAllocatedMemory;
    }

    public final Long getAccumulatedAllocatedMemory() {
        return ((ThreadMXBean)ManagementFactory.getThreadMXBean()).getThreadAllocatedBytes(Thread.currentThread().getId()) - this.getInitialAllocatedMemory();
    }

    public final Long getInitialTime() {
        return this.initialTime;
    }

    private void setInitialTime(Long initialTime) {
        this.initialTime = initialTime;
    }

    public final Long getAccumulatedTime() {
        return ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime() - this.getInitialTime();
    }

    public final void setSession(ServiceSession session) {
        if (this.session != null) {
            this.session.endThread();
        }
        if (session != null) {
            session.startThread();
            this.setInitialAllocatedMemory(((ThreadMXBean)ManagementFactory.getThreadMXBean()).getThreadAllocatedBytes(Thread.currentThread().getId()));
            this.setInitialTime(ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime());
            ServiceThread.configureMaxAllocatedMemory(SystemProperties.getLong("max.allocated.memory.for.thread"));
            ServiceThread.configureMaxExecutionTime(SystemProperties.getLong("max.execution.time.for.thread"));
        }
        this.session = session;
    }

    public static void configureMaxAllocatedMemory(Long maxAllocatedMemory) {
        if (SystemProperties.getBoolean("hcjf.service.max.allocated.memory.expressed.in.percentage").booleanValue()) {
            maxAllocatedMemory = maxAllocatedMemory == null || maxAllocatedMemory < 1L || maxAllocatedMemory > 100L ? Long.valueOf(Runtime.getRuntime().maxMemory()) : Long.valueOf(maxAllocatedMemory * Runtime.getRuntime().maxMemory() / 100L);
        } else if (maxAllocatedMemory == null || maxAllocatedMemory < 1L || maxAllocatedMemory > Runtime.getRuntime().maxMemory()) {
            maxAllocatedMemory = Runtime.getRuntime().maxMemory();
        }
        ((ServiceThread)Thread.currentThread()).setMaxAllocatedMemory(maxAllocatedMemory);
    }

    public static void configureMaxExecutionTime(Long maxExecutionTime) {
        if (maxExecutionTime == null || maxExecutionTime < 1L) {
            maxExecutionTime = Long.MAX_VALUE;
        }
        ((ServiceThread)Thread.currentThread()).setMaxExecutionTime(maxExecutionTime);
    }

    public static void checkInterruptedThread() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Service thread interrupted");
        }
    }

    public static void checkAllocatedMemory() throws Throwable {
        ServiceThread serviceThread = (ServiceThread)Thread.currentThread();
        if (serviceThread.getAccumulatedAllocatedMemory() > serviceThread.getMaxAllocatedMemory()) {
            serviceThread.setInitialAllocatedMemory(((ThreadMXBean)ManagementFactory.getThreadMXBean()).getThreadAllocatedBytes(Thread.currentThread().getId()));
            if (SystemProperties.getBoolean("max.allocated.memory.exceeded.throws.exception").booleanValue()) {
                throw new RuntimeException("Max memory allocated for thread exceeded");
            }
            Log.w(SystemProperties.get("SERVICE_THREAD"), "Max memory allocated for thread exceeded", new Object[0]);
        }
    }

    public static void checkExecutionTime() throws Throwable {
        ServiceThread serviceThread = (ServiceThread)Thread.currentThread();
        if (serviceThread.getAccumulatedTime() > serviceThread.getMaxExecutionTime()) {
            serviceThread.setInitialTime(ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime());
            throw new RuntimeException("Max execution time for thread exceeded");
        }
    }
}

