/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.utils;

import java.util.ArrayList;
import java.util.List;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.utils.Matrix;

public class Maths {
    private static final double ERROR_THRESHOLD = 0.001;
    private static final int DEGREE = 3;

    public static List<Number> linearRegression(List<Number> xDataSet, List<Number> yDataSet, List<Number> independentDataSet) {
        Double xSum = 0.0;
        Double xSum2 = 0.0;
        Double ySum = 0.0;
        Double xySum = 0.0;
        for (int i = 0; i < xDataSet.size(); ++i) {
            xSum = xSum2 + xDataSet.get(i).doubleValue();
            xSum2 = xSum2 + xDataSet.get(i).doubleValue() * xDataSet.get(i).doubleValue();
            ySum = ySum + yDataSet.get(i).doubleValue();
            xySum = xySum + xDataSet.get(i).doubleValue() * yDataSet.get(i).doubleValue();
        }
        double n = xDataSet.size();
        Double b = (n * xySum - xSum * ySum) / (n * xSum2 - xSum * xSum);
        Double a = (ySum - b * xSum) / n;
        ArrayList<Number> result = new ArrayList<Number>();
        for (Number xd : independentDataSet) {
            result.add(a + b * xd.doubleValue());
        }
        return result;
    }

    public static List<Number> polynomialRegression(List<Number> xDataSet, List<Number> yDataSet, List<Number> independentDataSet) {
        return Maths.polynomialRegression(xDataSet, yDataSet, independentDataSet, 3, 0.001);
    }

    public static List<Number> polynomialRegression(List<Number> xDataSet, List<Number> yDataSet, List<Number> independentDataSet, Number degree, Number errorThreshold) {
        double max;
        int i;
        double sum;
        int k;
        double[] x = new double[xDataSet.size()];
        double[] y = new double[xDataSet.size()];
        int n = xDataSet.size();
        int intDegree = degree.intValue();
        double[][] m = new double[intDegree + 1][intDegree + 1];
        double[] t = new double[intDegree + 1];
        double[] a = new double[intDegree + 1];
        for (int i2 = 0; i2 < xDataSet.size(); ++i2) {
            x[i2] = xDataSet.get(i2).doubleValue();
            y[i2] = yDataSet.get(i2).doubleValue();
        }
        double[] s = new double[2 * intDegree + 1];
        for (k = 0; k <= 2 * intDegree; ++k) {
            sum = 0.0;
            for (i = 0; i < n; ++i) {
                sum += Math.pow(x[i], k);
            }
            s[k] = sum;
        }
        for (k = 0; k <= intDegree; ++k) {
            sum = 0.0;
            for (i = 0; i < n; ++i) {
                sum += Math.pow(x[i], k) * y[i];
            }
            t[k] = sum;
        }
        for (int i3 = 0; i3 <= intDegree; ++i3) {
            for (int j = 0; j <= intDegree; ++j) {
                m[i3][j] = s[i3 + j];
            }
        }
        for (int i4 = 0; i4 <= intDegree; ++i4) {
            double aux = m[i4][i4];
            for (int j = 0; j <= intDegree; ++j) {
                m[i4][j] = -m[i4][j] / aux;
            }
            t[i4] = t[i4] / aux;
            m[i4][i4] = 0.0;
        }
        double[] p = new double[intDegree + 1];
        p[0] = t[0];
        for (int i5 = 1; i5 <= intDegree; ++i5) {
            p[i5] = 0.0;
        }
        do {
            int i6;
            max = 0.0;
            for (i6 = 0; i6 <= intDegree; ++i6) {
                int j;
                a[i6] = t[i6];
                for (j = 0; j < i6; ++j) {
                    int n2 = i6;
                    a[n2] = a[n2] + m[i6][j] * a[j];
                }
                for (j = i6 + 1; j <= intDegree; ++j) {
                    int n3 = i6;
                    a[n3] = a[n3] + m[i6][j] * p[j];
                }
                double error = Math.abs((a[i6] - p[i6]) / a[i6]);
                if (!(error > max)) continue;
                max = error;
            }
            for (i6 = 0; i6 <= intDegree; ++i6) {
                p[i6] = a[i6];
            }
        } while (max > errorThreshold.doubleValue());
        ArrayList<Number> resultList = new ArrayList<Number>();
        for (Number xp : independentDataSet) {
            double result = 0.0;
            for (int i7 = 0; i7 < a.length; ++i7) {
                result += a[i7] * Math.pow(xp.doubleValue(), i7);
            }
            resultList.add(result);
        }
        return resultList;
    }

    public static Matrix matrixAdd(Matrix matrixA, Matrix matrixB) {
        if (matrixA.getRows() != matrixB.getRows() || matrixA.getCols() != matrixB.getCols()) {
            throw new HCJFRuntimeException("To add two matrix, these must have the same size", new Object[0]);
        }
        Matrix result = new Matrix(matrixA.getRows(), matrixA.getCols(), new Number[0]);
        for (int row = 0; row < matrixA.getRows(); ++row) {
            for (int col = 0; col < matrixA.getCols(); ++col) {
                result.set(row, col, matrixA.get(row, col) + matrixB.get(row, col));
            }
        }
        return result;
    }

    public static Matrix matrixSubtract(Matrix matrixA, Matrix matrixB) {
        if (matrixA.getRows() != matrixB.getRows() || matrixA.getCols() != matrixB.getCols()) {
            throw new HCJFRuntimeException("To subtract two matrix, these must have the same size", new Object[0]);
        }
        Matrix result = new Matrix(matrixA.getRows(), matrixA.getCols(), new Number[0]);
        for (int row = 0; row < matrixA.getRows(); ++row) {
            for (int col = 0; col < matrixA.getCols(); ++col) {
                result.set(row, col, matrixA.get(row, col) - matrixB.get(row, col));
            }
        }
        return result;
    }

    public static Matrix matrixMultiplyByScalar(Matrix matrix, Number scalar) {
        Matrix result = new Matrix(matrix.getRows(), matrix.getCols(), new Number[0]);
        for (int row = 0; row < matrix.getRows(); ++row) {
            for (int col = 0; col < matrix.getCols(); ++col) {
                result.set(row, col, matrix.get(row, col) * scalar.doubleValue());
            }
        }
        return result;
    }

    public static Matrix matrixMultiply(Matrix matrixA, Matrix matrixB) {
        if (matrixA.getCols() != matrixB.getRows()) {
            throw new HCJFRuntimeException("To multiply two matrix the first matrix columns size must be equals than the second matrix row size", new Object[0]);
        }
        Matrix result = new Matrix(matrixA.getRows(), matrixB.getCols(), new Number[0]);
        for (int rowA = 0; rowA < matrixA.getRows(); ++rowA) {
            for (int colB = 0; colB < matrixB.getCols(); ++colB) {
                double sum = 0.0;
                for (int i = 0; i < matrixA.getCols(); ++i) {
                    sum += matrixA.get(rowA, i) * matrixB.get(i, colB);
                }
                result.set(rowA, colB, sum);
            }
        }
        return result;
    }

    public static Matrix matrixTranspose(Matrix matrix) {
        Matrix transposedMatrix = new Matrix(matrix.getCols(), matrix.getRows(), new Number[0]);
        for (int row = 0; row < matrix.getRows(); ++row) {
            for (int col = 0; col < matrix.getCols(); ++col) {
                transposedMatrix.set(col, row, matrix.get(row, col));
            }
        }
        return transposedMatrix;
    }

    public static double matrixDeterminant(Matrix matrix) {
        double result;
        if (!matrix.isSquare()) {
            throw new HCJFRuntimeException("Matrix neet to be square", new Object[0]);
        }
        if (matrix.getRows() == 1) {
            result = matrix.get(0, 0);
        } else if (matrix.getRows() == 2) {
            result = matrix.get(0, 0) * matrix.get(1, 1) - matrix.get(0, 1) * matrix.get(1, 0);
        } else {
            result = 0.0;
            for (int i = 0; i < matrix.getCols(); ++i) {
                result += (double)(i % 2 == 0 ? 1 : -1) * matrix.get(0, i) * Maths.matrixDeterminant(Maths.createSubMatrix(matrix, 0, i));
            }
        }
        return result;
    }

    public static Matrix createSubMatrix(Matrix matrix, int excludingRow, int excludingCol) {
        Matrix mat = new Matrix(matrix.getRows() - 1, matrix.getCols() - 1, new Number[0]);
        int r = -1;
        for (int i = 0; i < matrix.getRows(); ++i) {
            if (i == excludingRow) continue;
            ++r;
            int c = -1;
            for (int j = 0; j < matrix.getCols(); ++j) {
                if (j == excludingCol) continue;
                mat.set(r, ++c, matrix.get(i, j));
            }
        }
        return mat;
    }

    public static Matrix matrixCofactor(Matrix matrix) {
        Matrix mat = new Matrix(matrix.getRows(), matrix.getCols(), new Number[0]);
        for (int i = 0; i < matrix.getRows(); ++i) {
            for (int j = 0; j < matrix.getCols(); ++j) {
                mat.set(i, j, (double)((i % 2 == 0 ? 1 : -1) * (j % 2 == 0 ? 1 : -1)) * Maths.matrixDeterminant(Maths.createSubMatrix(matrix, i, j)));
            }
        }
        return mat;
    }

    public static Matrix matrixInverse(Matrix matrix) {
        return Maths.matrixMultiplyByScalar(Maths.matrixTranspose(Maths.matrixCofactor(matrix)), 1.0 / Maths.matrixDeterminant(matrix));
    }
}

