/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.utils;

import java.util.ArrayList;
import org.hcjf.bson.BsonDocument;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.layers.Layers;
import org.hcjf.utils.MatrixBsonBuilderLayer;
import org.hcjf.utils.Strings;
import org.hcjf.utils.bson.BsonParcelable;

public final class Matrix
implements BsonParcelable {
    private int rows;
    private int cols;
    private double[][] data;

    public Matrix(double[][] dat) {
        this.data = dat;
        this.rows = dat.length;
        this.cols = dat[0].length;
    }

    public Matrix(int rows, int cols, Number ... values) {
        this.rows = rows;
        this.cols = cols;
        this.data = new double[rows][cols];
        int z = 0;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols && z < values.length; ++j) {
                this.data[i][j] = values[z++].doubleValue();
            }
            if (z >= values.length) break;
        }
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public double[][] getData() {
        double[][] result = new double[this.rows][this.cols];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                result[i][j] = this.data[i][j];
            }
        }
        return result;
    }

    public boolean isSquare() {
        return this.rows == this.cols;
    }

    private void checkRange(int row, int col) {
        if (row < 0 || row >= this.rows) {
            throw new HCJFRuntimeException("Matrix [%s, %s] row out of range: %s", this.rows, this.cols, row);
        }
        if (col < 0 || col >= this.cols) {
            throw new HCJFRuntimeException("Matrix [%s, %s] col out of range: %s", this.rows, this.cols, col);
        }
    }

    public void set(int row, int col, Number value) {
        this.checkRange(row, col);
        this.data[row][col] = value.doubleValue();
        if (Double.compare(this.data[row][col], -0.0) == 0) {
            this.data[row][col] = 0.0;
        }
    }

    public double get(int row, int col) {
        this.checkRange(row, col);
        return this.data[row][col];
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof Matrix) {
            Matrix matrix = (Matrix)o;
            result = true;
            for (int row = 0; row < this.rows; ++row) {
                for (int col = 0; col < this.cols; ++col) {
                    if (Double.compare(this.get(row, col), matrix.get(row, col)) == 0) continue;
                    result = false;
                    break;
                }
                if (!result) break;
            }
        }
        return result;
    }

    public String toString() {
        Strings.Builder builder = new Strings.Builder();
        int length = 0;
        ArrayList<String> values = new ArrayList<String>();
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                String value = Double.toString(this.get(row, col));
                if (length < value.length()) {
                    length = value.length();
                }
                values.add(value);
            }
        }
        int z = 0;
        for (int row = 0; row < this.rows; ++row) {
            builder.append("|");
            for (int col = 0; col < this.cols; ++col) {
                builder.append(Strings.leftPad((String)values.get(z++), length), ",");
            }
            builder.cleanBuffer();
            builder.append("|");
            builder.append("\r\n");
        }
        builder.cleanBuffer();
        return builder.toString();
    }

    public static Matrix identity(int size) {
        Matrix identity = new Matrix(size, size, new Number[0]);
        for (int i = 0; i < size; ++i) {
            identity.set(i, i, 1);
        }
        return identity;
    }

    @Override
    public BsonDocument toBson() {
        BsonDocument document = new BsonDocument();
        document.put("__pcn__", (Object)this.getClass().getName());
        document.put("rows", (Object)this.rows);
        document.put("cols", (Object)this.cols);
        ArrayList<Double> dataList = new ArrayList<Double>();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                dataList.add(this.data[i][j]);
            }
        }
        document.put("data", dataList);
        return document;
    }

    static {
        Layers.publishLayer(MatrixBsonBuilderLayer.class);
    }

    public static final class Fields {
        public static final String ROWS = "rows";
        public static final String COLS = "cols";
        public static final String DATA = "data";
    }
}

