/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hcjf.layers.Layer;
import org.hcjf.layers.LayerInterface;
import org.hcjf.layers.Layers;
import org.hcjf.layers.distributed.DistributedLayerInterface;
import org.hcjf.utils.Strings;

public final class XmlUtils {
    public static void main(String[] args) throws Exception {
        Layers.publishLayer(XMLPrinter.class);
        Layers.publishLayer(JsonPrinter.class);
        Layers.get(Printer.class, "csv").print(Map.of());
    }

    public static void main1(String[] args) throws Exception {
    }

    public static Map<String, Object> parse(String xml) {
        List<String> commentGroups = Strings.replaceableGroup(xml, "<!--", "-->");
        String uncommentedXml = commentGroups.get(commentGroups.size() - 1);
        for (int i = 0; i < commentGroups.size() - 1; ++i) {
            uncommentedXml = uncommentedXml.replace(String.format("\u00bf%d\u00b7", i), "");
        }
        HashMap<String, String> cdataValues = new HashMap<String, String>();
        List<String> cdataGroups = Strings.replaceableGroup(uncommentedXml, "<![CDATA[", "]]>");
        String cleanXml = cdataGroups.get(cdataGroups.size() - 1);
        for (int i = 0; i < cdataGroups.size() - 1; ++i) {
            String cdataKey = String.format("__\u00bfCDATA__%d\u00bf__", i);
            cdataValues.put(cdataKey, cdataGroups.get(i));
            cleanXml = cleanXml.replace(String.format("\u00bf%d\u00b7", i), cdataKey);
        }
        List<String> groups = Strings.group(cleanXml, "<", ">", false, (Boolean)false);
        AtomicInteger index = new AtomicInteger(groups.size() - 1);
        HashMap<String, Object> result = new HashMap<String, Object>();
        do {
            result.putAll(XmlUtils.parse(new HashMap<String, Object>(), groups, index, new AtomicInteger(0), cdataValues));
            index.decrementAndGet();
        } while (index.get() >= 0);
        result.remove("__\u00bfHAS_CHILDREN\u00bf__");
        return result;
    }

    private static Map<String, Object> parse(Map<String, Object> currentObject, List<String> groups, AtomicInteger index, AtomicInteger lastIndexOf, Map<String, String> cdataValues) {
        String currentTag = groups.get(index.get());
        if (currentTag.startsWith("/")) {
            if (!currentObject.containsKey("__\u00bfHAS_CHILDREN\u00bf__")) {
                Integer currentIndex = index.get();
                currentObject.put("_value", XmlUtils.getValue(groups, currentIndex + 1, currentIndex, lastIndexOf, cdataValues));
            } else {
                currentObject.remove("__\u00bfHAS_CHILDREN\u00bf__");
            }
            currentObject.put("__\u00bfCLOSED\u00bf__", true);
        } else if (currentTag.endsWith("/")) {
            currentTag = currentTag.replace("/", "");
            String tagName = XmlUtils.getName(currentTag);
            Map<String, Object> child = XmlUtils.getAttributes(currentTag);
            currentObject = XmlUtils.addChild(currentObject, tagName, child);
        } else if (currentTag.startsWith("?")) {
            index.decrementAndGet();
            currentObject = XmlUtils.parse(currentObject, groups, index, lastIndexOf, cdataValues);
        } else {
            String tagName = XmlUtils.getName(currentTag);
            Map<String, Object> child = XmlUtils.getAttributes(currentTag);
            do {
                index.decrementAndGet();
            } while (!(child = XmlUtils.parse(child, groups, index, lastIndexOf, cdataValues)).containsKey("__\u00bfCLOSED\u00bf__"));
            child.remove("__\u00bfCLOSED\u00bf__");
            currentObject = XmlUtils.addChild(currentObject, tagName, child);
            currentObject.put("__\u00bfHAS_CHILDREN\u00bf__", true);
        }
        return currentObject;
    }

    private static Map<String, Object> addChild(Map<String, Object> currentObject, String tagName, Map<String, Object> child) {
        Object childToAdd = child;
        if (child.size() == 1 && child.containsKey("_value")) {
            childToAdd = child.get("_value");
        }
        if (currentObject.containsKey(tagName)) {
            Object value = currentObject.get(tagName);
            if (value instanceof List) {
                ((List)value).add(childToAdd);
            } else {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(value);
                list.add(childToAdd);
                currentObject.put(tagName, list);
            }
        } else {
            currentObject.put(tagName, childToAdd);
        }
        return currentObject;
    }

    private static String getName(String tag) {
        String[] tagParts = tag.split(" ");
        return tagParts[0].trim();
    }

    private static Map<String, Object> getAttributes(String tag) {
        Matcher matcher = Patterns.TAG_ATTRIBUTES_PATTERN.matcher(tag);
        HashMap<String, Object> result = new HashMap<String, Object>();
        int start = 0;
        while (matcher.find(start)) {
            String attribute = matcher.group("attribute").trim();
            String[] keyValue = attribute.split("=");
            if (keyValue.length == 1) {
                result.put(keyValue[0], null);
            } else {
                result.put(keyValue[0], Strings.deductInstance(keyValue[1].substring(1, keyValue[1].length() - 1)));
            }
            start = matcher.end();
        }
        return result;
    }

    private static Object getValue(List<String> groups, int startIndex, int endIndex, AtomicInteger lastIndexOf, Map<String, String> cdataValues) {
        return "";
    }

    public static String toXml(Map<String, Object> root) {
        StringBuilder result = new StringBuilder();
        for (String key : root.keySet()) {
            Object value = root.get(key);
            if (!(value instanceof Map) && !(value instanceof Collection)) continue;
        }
        return result.toString();
    }

    private static String toXml(StringBuilder builder, Map<String, Object> tag) {
        for (String key : tag.keySet()) {
            Object value = tag.get(key);
            if (tag.size() == 1) {
                if (value instanceof Map || value instanceof Collection) continue;
                if (value != null) {
                    builder.append(String.format("<%s%s>", key, ""));
                    builder.append(value);
                    builder.append(String.format("</%s>", key));
                    continue;
                }
                builder.append(String.format("<%s%s>", key, "/"));
                continue;
            }
            if (!(value instanceof Map) && !(value instanceof Collection)) continue;
        }
        return null;
    }

    public static class JsonPrinter
    extends Layer
    implements Printer {
        @Override
        public String getImplName() {
            return "json";
        }

        @Override
        public void print(Map<String, Object> obj) {
            System.out.println("Imprime como Json");
        }
    }

    public static class XMLPrinter
    extends Layer
    implements Printer,
    DistributedLayerInterface {
        @Override
        public String getImplName() {
            return "xml";
        }

        @Override
        public void print(Map<String, Object> obj) {
            System.out.println("Imprime como XML");
        }
    }

    public static interface Printer
    extends LayerInterface {
        public void print(Map<String, Object> var1);
    }

    private static final class Patterns {
        private static final String OPEN_TAG = "<%s%s>";
        private static final String CLOSE_TAG = "</%s>";
        private static final String ATTRIBUTE = " %s=\"%s\"";
        private static final String CDATA = "<![CDATA[%s]]>";
        private static final String ATTRIBUTE_GROUP_NAME = "attribute";
        private static final Pattern TAG_ATTRIBUTES_PATTERN = Pattern.compile("(?<attribute>[a-zA-Z0-9_\\-]+[ ]*=[ ]*\"[a-zA-Z0-9_\\-.:/+*#$%& ]+\"[ ]*)");

        private Patterns() {
        }
    }

    private static final class Fields {
        private static final String VERSION = "_version";
        private static final String VALUE = "_value";
        private static final String HAS_CHILDREN = "__\u00bfHAS_CHILDREN\u00bf__";
        private static final String CLOSED = "__\u00bfCLOSED\u00bf__";
        private static final String TOKEN_FORMAT = "\u00bf%d\u00b7";
        private static final String COMMENT_START = "<!--";
        private static final String COMMENT_END = "-->";
        private static final String CDATA_START = "<![CDATA[";
        private static final String CDATA_END = "]]>";
        private static final String CDATA = "__\u00bfCDATA__%d\u00bf__";

        private Fields() {
        }
    }
}

