/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hcjf.errors.Errors;
import org.hcjf.io.net.http.Cookie;
import org.hcjf.io.net.http.Cookie2;
import org.hcjf.io.net.http.HttpHeader;
import org.hcjf.layers.Layer;
import org.hcjf.layers.LayerInterface;
import org.hcjf.layers.Layers;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;

public abstract class HttpPackage {
    private static final byte LINE_SEPARATOR_CR = 13;
    private static final byte LINE_SEPARATOR_LF = 10;
    public static final String STRING_LINE_SEPARATOR = "\r\n";
    public static final String LINE_FIELD_SEPARATOR = " ";
    public static final String HTTP_FIELD_START = "?";
    public static final String HTTP_FIELD_SEPARATOR = "&";
    public static final String HTTP_FIELD_ASSIGNATION = "=";
    public static final String HTTP_CONTEXT_SEPARATOR = "/";
    private HttpProtocol protocol;
    private String httpVersion;
    private final Map<String, HttpHeader> headers;
    private final Map<String, Cookie> cookies;
    private byte[] body;
    private List<String> lines;
    private boolean onBody;
    private boolean complete;
    private ByteArrayOutputStream currentBuffer;
    private TransferDecodingLayerInterface transferDecodingLayer;

    public HttpPackage() {
        this.httpVersion = "HTTP/1.1";
        this.headers = new HashMap<String, HttpHeader>();
        this.cookies = new HashMap<String, Cookie>();
        this.body = new byte[0];
        this.protocol = HttpProtocol.HTTP;
    }

    protected HttpPackage(HttpPackage httpPackage) {
        this.httpVersion = httpPackage.httpVersion;
        this.headers = httpPackage.headers;
        this.cookies = httpPackage.cookies;
        this.body = httpPackage.body;
        this.protocol = httpPackage.protocol;
    }

    public HttpProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(HttpProtocol protocol) {
        this.protocol = protocol;
    }

    public final byte[] getBody() {
        return this.body;
    }

    public final void setBody(byte[] body) {
        this.body = body;
    }

    public final String getHttpVersion() {
        return this.httpVersion;
    }

    public final void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public final boolean isComplete() {
        return this.complete;
    }

    public TransferDecodingLayerInterface getTransferDecodingLayer() {
        return this.transferDecodingLayer;
    }

    public void setTransferDecodingLayer(TransferDecodingLayerInterface transferDecodingLayer) {
        this.transferDecodingLayer = transferDecodingLayer;
    }

    public final void addHeader(HttpHeader header) {
        if (header == null) {
            throw new NullPointerException("Null header");
        }
        if (header.getHeaderName().equals("Cookie")) {
            this.processCookieHeader(header);
        } else if (header.getHeaderName().equals("Set-Cookie") || header.getHeaderName().equals("Set-Cookie2")) {
            this.processSetCookieHeader(header);
        } else {
            this.headers.put(header.getHeaderName(), header);
        }
    }

    private void processCookieHeader(HttpHeader httpHeader) {
        try {
            String[] cookies;
            for (String cookie : cookies = httpHeader.getHeaderValue().split(";")) {
                String[] name_value = cookie.split(HTTP_FIELD_ASSIGNATION);
                this.addCookie(new Cookie(name_value[0].trim(), name_value[1].trim()));
            }
        }
        catch (Exception ex) {
            Log.w(SystemProperties.get("hcjf.net.http.server.log.tag"), "Error parsing cookie header: %s", ex, httpHeader.toString());
        }
    }

    private void processSetCookieHeader(HttpHeader httpHeader) {
        try {
            String[] params = httpHeader.getHeaderValue().split(";");
            String[] name_value = params[0].split(HTTP_FIELD_ASSIGNATION);
            Cookie cookie = httpHeader.getHeaderName().equals("Set-Cookie2") ? new Cookie2(name_value[0].trim(), name_value[1].trim()) : new Cookie(name_value[0].trim(), name_value[1].trim());
            for (int i = 1; i < params.length; ++i) {
                String param = params[i].trim();
                if (param.startsWith("Comment")) {
                    cookie.setComment(param.substring(param.indexOf(HTTP_FIELD_ASSIGNATION) + 1).trim());
                    continue;
                }
                if (param.startsWith("Domain")) {
                    cookie.setDomain(param.substring(param.indexOf(HTTP_FIELD_ASSIGNATION) + 1).trim());
                    continue;
                }
                if (param.startsWith("Max-Age")) {
                    cookie.setMaxAge(Integer.parseInt(param.substring(param.indexOf(HTTP_FIELD_ASSIGNATION) + 1).trim()));
                    continue;
                }
                if (param.startsWith("Path")) {
                    cookie.setPath(param.substring(param.indexOf(HTTP_FIELD_ASSIGNATION) + 1).trim());
                    continue;
                }
                if (param.startsWith("Secure")) {
                    cookie.setSecure(true);
                    continue;
                }
                if (param.startsWith("Version")) {
                    cookie.setVersion(Integer.parseInt(param.substring(param.indexOf(HTTP_FIELD_ASSIGNATION) + 1).trim()));
                    continue;
                }
                if (cookie instanceof Cookie2 && param.startsWith("CommentURL")) {
                    ((Cookie2)cookie).setCommentUrl(param.substring(param.indexOf(HTTP_FIELD_ASSIGNATION) + 1).trim());
                    continue;
                }
                if (cookie instanceof Cookie2 && param.startsWith("Discard")) {
                    ((Cookie2)cookie).setDiscard(true);
                    continue;
                }
                if (!(cookie instanceof Cookie2) || !param.startsWith("PORT")) continue;
                ((Cookie2)cookie).setPort(Integer.parseInt(param.substring(param.indexOf(HTTP_FIELD_ASSIGNATION) + 1).trim()));
            }
            this.addCookie(cookie);
        }
        catch (Exception ex) {
            Log.w(SystemProperties.get("hcjf.net.http.server.log.tag"), "Error parsing cookie header: %s", ex, httpHeader.toString());
        }
    }

    public final Collection<HttpHeader> getHeaders() {
        return Collections.unmodifiableCollection(this.headers.values());
    }

    public final HttpHeader getHeader(String headerName) {
        HttpHeader result = null;
        for (String name : this.headers.keySet()) {
            if (!name.equalsIgnoreCase(headerName)) continue;
            result = this.headers.get(name);
        }
        return result;
    }

    public final boolean containsHeader(String headerName) {
        return this.getHeader(headerName) != null;
    }

    public final void addCookie(Cookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("Null cookie");
        }
        this.cookies.put(cookie.getName(), cookie);
    }

    public final Collection<Cookie> getCookies() {
        return Collections.unmodifiableCollection(this.cookies.values());
    }

    public final Cookie getCookie(String name) {
        return this.cookies.get(name);
    }

    public final boolean containsCookie(String name) {
        return this.cookies.containsKey(name);
    }

    public final synchronized void addData(byte[] data) {
        if (!this.complete) {
            if (this.currentBuffer == null) {
                this.currentBuffer = new ByteArrayOutputStream();
                this.lines = new ArrayList<String>();
                this.onBody = false;
                this.complete = false;
            }
            if (this.onBody) {
                this.writeBody(data);
            } else {
                for (int i = 0; i < data.length; ++i) {
                    if (i + 1 == data.length) {
                        if (data[i] == 10) continue;
                        this.currentBuffer.write(data[i]);
                        continue;
                    }
                    if (data[i] == 13 && data[i + 1] == 10) {
                        if (this.currentBuffer.size() == 0) {
                            for (int j = 1; j < this.lines.size(); ++j) {
                                this.addHeader(new HttpHeader(this.lines.get(j)));
                            }
                            HttpHeader transferEncodingHeader = this.getHeader("Transfer-Encoding");
                            if (transferEncodingHeader != null && this.transferDecodingLayer == null) {
                                try {
                                    this.transferDecodingLayer = Layers.get(TransferDecodingLayerInterface.class, transferEncodingHeader.getHeaderValue());
                                }
                                catch (Exception ex) {
                                    Log.w(SystemProperties.get("hcjf.net.http.server.log.tag"), "Transfer decoding layer not found", ex, new Object[0]);
                                }
                            }
                            this.currentBuffer.reset();
                            this.writeBody(data, i + 2, data.length - (i + 2));
                            this.onBody = true;
                            break;
                        }
                        String line = new String(this.currentBuffer.toByteArray()).trim();
                        if (!line.isEmpty()) {
                            this.lines.add(line);
                        }
                        this.currentBuffer.reset();
                        ++i;
                        continue;
                    }
                    this.currentBuffer.write(data[i]);
                }
            }
            if (this.onBody && this.bodyDone()) {
                this.setBody(this.getAccumulatedBody());
                this.processFirstLine(this.lines.get(0));
                this.processBody();
                this.currentBuffer = null;
                this.complete = true;
            }
        } else {
            Log.d(SystemProperties.get("hcjf.net.http.server.log.tag"), "Trying to add data into a complete http package.", new Object[0]);
        }
    }

    private void writeBody(byte[] data) {
        this.writeBody(data, 0, data.length);
    }

    private void writeBody(byte[] data, int offset, int length) {
        if (this.transferDecodingLayer == null) {
            this.currentBuffer.write(data, offset, length);
            if (this.currentBuffer.size() > SystemProperties.getInteger("hcjf.net.http.max.package.size")) {
                throw new RuntimeException(Errors.getMessage("org.hcjf.io.net.http.package.overflow", new Object[0]));
            }
        } else {
            byte[] fragment;
            if (offset == 0 && length == data.length) {
                fragment = data;
            } else {
                fragment = new byte[length];
                System.arraycopy(data, offset, fragment, 0, length);
            }
            this.transferDecodingLayer.add(ByteBuffer.wrap(fragment));
        }
    }

    private byte[] getAccumulatedBody() {
        byte[] result = this.transferDecodingLayer == null ? this.currentBuffer.toByteArray() : this.transferDecodingLayer.getBody();
        return result;
    }

    protected boolean bodyDone() {
        boolean result;
        if (this.transferDecodingLayer == null) {
            int length = 0;
            HttpHeader contentLengthHeader = this.getHeader("Content-Length");
            if (contentLengthHeader != null) {
                length = Integer.parseInt(contentLengthHeader.getHeaderValue().trim());
            }
            result = this.currentBuffer.size() >= length;
        } else {
            result = this.transferDecodingLayer.done(this);
        }
        return result;
    }

    protected byte[] trimBody(byte[] body) {
        return body;
    }

    protected abstract void processBody();

    protected abstract void processFirstLine(String var1);

    public abstract byte[] getProtocolHeader();

    static {
        Layers.publishLayer(ChunkedDecoderLayer.class);
    }

    public static enum HttpProtocol {
        HTTP,
        HTTPS;

    }

    public static interface TransferDecodingLayerInterface
    extends LayerInterface {
        public void add(ByteBuffer var1);

        public boolean done(HttpPackage var1);

        public byte[] getBody();
    }

    public static class ChunkedDecoderLayer
    extends Layer
    implements TransferDecodingLayerInterface {
        private static final int DEFAULT_SIZE = -1;
        private static final byte SLASH_R_BYTE = 13;
        private int fragmentSize = -1;
        private int byteWritten = 0;
        private final ByteArrayOutputStream lengthBuffer;
        private final ByteArrayOutputStream bodyBuffer = new ByteArrayOutputStream();
        private boolean done = false;

        public ChunkedDecoderLayer() {
            super("chunked", false);
            this.lengthBuffer = new ByteArrayOutputStream();
        }

        @Override
        public void add(ByteBuffer bodyFragment) {
            while (bodyFragment.position() < bodyFragment.limit()) {
                if (this.fragmentSize == -1) {
                    byte currentByte = bodyFragment.get();
                    if (currentByte == 13) {
                        this.fragmentSize = Integer.parseInt(this.lengthBuffer.toString(), 16);
                        this.lengthBuffer.reset();
                        this.byteWritten = -1;
                        if (this.fragmentSize != 0) continue;
                        this.done = true;
                        break;
                    }
                    this.lengthBuffer.write(currentByte);
                    continue;
                }
                if (this.byteWritten == -1) {
                    bodyFragment.get();
                    ++this.byteWritten;
                    continue;
                }
                if (this.byteWritten == this.fragmentSize) {
                    bodyFragment.get();
                    bodyFragment.get();
                    this.fragmentSize = -1;
                    continue;
                }
                this.bodyBuffer.write(bodyFragment.get());
                ++this.byteWritten;
            }
        }

        @Override
        public boolean done(HttpPackage httpPackage) {
            return this.done;
        }

        @Override
        public byte[] getBody() {
            return this.bodyBuffer.toByteArray();
        }
    }
}

