/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.io.net.http.HttpHeader;
import org.hcjf.io.net.http.HttpPackage;
import org.hcjf.layers.Layer;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.Service;
import org.hcjf.service.ServiceSession;
import org.hcjf.service.ServiceThread;

public abstract class HttpResponseHandler
extends Layer
implements HttpPackage.TransferDecodingLayerInterface {
    private final Queue<ByteBuffer> queue = new ArrayBlockingQueue<ByteBuffer>(SystemProperties.getInteger("hcjf.net.http.client.response.handler.queue.size"));
    private Throwable throwable;
    private Boolean done = false;
    private Long length;
    private final AtomicLong counter = new AtomicLong();

    public HttpResponseHandler() {
        if (Thread.currentThread() instanceof ServiceThread) {
            Service.run(this::consume, ServiceSession.getCurrentIdentity());
        } else {
            new Thread(this::consume).start();
        }
    }

    @Override
    public String getImplName() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void add(ByteBuffer bodyFragment) {
        try {
            this.queue.offer(bodyFragment);
            Queue<ByteBuffer> queue = this.queue;
            synchronized (queue) {
                this.queue.notifyAll();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.throwable = ex;
            HttpResponseHandler httpResponseHandler = this;
            synchronized (httpResponseHandler) {
                this.notifyAll();
            }
        }
    }

    @Override
    public final boolean done(HttpPackage httpPackage) {
        HttpHeader contentLengthHeader;
        if (this.length == null && (contentLengthHeader = httpPackage.getHeader("Content-Length")) != null) {
            this.length = Long.parseLong(contentLengthHeader.getHeaderValue().trim());
        }
        if (this.counter.get() >= this.length) {
            this.done = true;
        }
        return this.done;
    }

    @Override
    public final byte[] getBody() {
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void consume() {
        try {
            while (!Thread.currentThread().isInterrupted() && !this.done.booleanValue()) {
                Queue<ByteBuffer> queue = this.queue;
                // MONITORENTER : queue
                ByteBuffer fragment = this.queue.poll();
                // MONITOREXIT : queue
                if (fragment != null) {
                    this.consume(fragment);
                    this.counter.addAndGet(fragment.limit());
                    continue;
                }
                queue = this.queue;
                // MONITORENTER : queue
                try {
                    this.queue.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.throwable = ex;
        }
        HttpResponseHandler httpResponseHandler = this;
        // MONITORENTER : httpResponseHandler
        this.notifyAll();
        // MONITOREXIT : httpResponseHandler
    }

    protected abstract void consume(ByteBuffer var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void get() {
        HttpResponseHandler httpResponseHandler = this;
        synchronized (httpResponseHandler) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.throwable != null) {
            throw new HCJFRuntimeException("Response handler fail", this.throwable, new Object[0]);
        }
    }
}

