/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.hcjf.io.net.NetPackage;
import org.hcjf.io.net.NetServer;
import org.hcjf.io.net.NetService;
import org.hcjf.io.net.NetServiceConsumer;
import org.hcjf.io.net.NetSession;
import org.hcjf.io.net.http.Context;
import org.hcjf.io.net.http.HttpHeader;
import org.hcjf.io.net.http.HttpMethod;
import org.hcjf.io.net.http.HttpPackage;
import org.hcjf.io.net.http.HttpRequest;
import org.hcjf.io.net.http.HttpResponse;
import org.hcjf.io.net.http.HttpResponseCode;
import org.hcjf.io.net.http.HttpSession;
import org.hcjf.io.net.http.HttpSessionManager;
import org.hcjf.io.net.http.http2.Stream;
import org.hcjf.io.net.http.http2.StreamSettings;
import org.hcjf.io.net.http.http2.frames.DataFrame;
import org.hcjf.io.net.http.http2.frames.Http2Frame;
import org.hcjf.io.net.http.http2.frames.SettingsFrame;
import org.hcjf.io.net.http.http2.frames.WindowsUpdateFrame;
import org.hcjf.io.net.http.pipeline.HttpPipelineResponse;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.Service;
import org.hcjf.service.ServiceSession;
import org.hcjf.utils.Strings;
import org.hcjf.utils.io.net.http.HttpUtils;

public class HttpServer
extends NetServer<HttpSession, HttpPackage> {
    private final Map<NetSession, HttpRequest> requestBuffers = new HashMap<NetSession, HttpRequest>();
    private final List<Context> contexts = new ArrayList<Context>();
    private HttpSessionManager sessionManager;
    private HttpPackage.HttpProtocol httpProtocol;
    private final Map<String, AccessControl> accessControlMap = new HashMap<String, AccessControl>();

    public HttpServer() {
        this(SystemProperties.getInteger("hcjf.net.http.default.server.port"));
    }

    public HttpServer(Integer port) {
        this(port, false);
    }

    protected HttpServer(Integer port, boolean sslProtocol) {
        super(port, sslProtocol ? NetService.TransportLayerProtocol.TCP_SSL : NetService.TransportLayerProtocol.TCP, false, true);
        HttpPackage.HttpProtocol httpProtocol = this.httpProtocol = sslProtocol ? HttpPackage.HttpProtocol.HTTPS : HttpPackage.HttpProtocol.HTTP;
        if (SystemProperties.getBoolean("hcjf.net.http.server.decoupled.io.action").booleanValue()) {
            this.decoupleIoAction(SystemProperties.getInteger("hcjf.net.http.server.io.queue.size"), SystemProperties.getInteger("hcjf.net.http.server.io.workers"));
        }
    }

    public static void create(Integer port, Context ... contexts) {
        HttpServer server = new HttpServer(port);
        for (Context context : contexts) {
            server.addContext(context);
        }
        server.start();
    }

    public final void addAccessControl(AccessControl accessControl) {
        this.accessControlMap.put(accessControl.getDomain(), accessControl);
    }

    public final HttpSessionManager getSessionManager() {
        return this.sessionManager;
    }

    public final void setSessionManager(HttpSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Override
    public final HttpSession createSession(NetPackage netPackage) {
        HttpSessionManager sessionManager = this.getSessionManager();
        if (sessionManager == null) {
            sessionManager = HttpSessionManager.DEFAULT;
        }
        HttpSession session = sessionManager.createSession(this, netPackage);
        Log.d(SystemProperties.get("hcjf.net.http.server.log.tag"), "[CREATE_SESSION] Http session %s", session);
        return session;
    }

    @Override
    public HttpSession checkSession(HttpSession session, HttpPackage payLoad, NetPackage netPackage) {
        HttpSessionManager sessionManager = this.getSessionManager();
        if (sessionManager == null) {
            sessionManager = HttpSessionManager.DEFAULT;
        }
        HttpSession checkedSession = sessionManager.checkSession(session, (HttpRequest)payLoad);
        Log.d(SystemProperties.get("hcjf.net.http.server.log.tag"), "[CHECK_SESSION] Http session %s", session);
        return checkedSession;
    }

    @Override
    protected final byte[] encode(HttpPackage payLoad) {
        byte[] result = null;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            if (payLoad instanceof HttpPipelineResponse) {
                if (((HttpPipelineResponse)payLoad).isFirstRead()) {
                    out.write(payLoad.getProtocolHeader());
                }
                ByteBuffer mainBuffer = ((HttpPipelineResponse)payLoad).getMainBuffer();
                out.write(mainBuffer.array(), 0, mainBuffer.position());
                out.flush();
            } else {
                out.write(payLoad.getProtocolHeader());
                out.write(payLoad.getBody());
                out.flush();
            }
            result = out.toByteArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final HttpPackage decode(NetPackage netPackage) {
        HttpRequest request = null;
        if (((HttpSession)netPackage.getSession()).getHttpVersion().equals("HTTP/2.0")) {
            Stream stream = ((HttpSession)netPackage.getSession()).getStream();
            byte[] data = netPackage.getPayload();
            if (stream.getHttpClientPreface() == null) {
                String httpClientPreface = new String(data, 0, 24);
                stream.setHttpClientPreface(httpClientPreface);
                stream.addData(data, 24);
            } else {
                stream.addData(data, 0);
            }
            for (Http2Frame frame : stream.getAndRemoveFrames()) {
                byte[] responseData;
                if (frame instanceof SettingsFrame) {
                    SettingsFrame settingsFrame = (SettingsFrame)frame;
                    if (settingsFrame.getFlags() != 1) {
                        try {
                            responseData = SettingsFrame.createDefaultSettingsFrame(0).serialize().array();
                            this.getService().writeData(netPackage.getSession(), responseData);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    DataFrame dataFrame = new DataFrame(0, (byte)0, 0);
                    dataFrame.setData(ByteBuffer.wrap("Hola Mundo".getBytes()));
                    dataFrame.setPathLength((byte)0);
                    try {
                        this.getService().writeData(netPackage.getSession(), dataFrame.serialize().array());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!(frame instanceof WindowsUpdateFrame)) continue;
                WindowsUpdateFrame windowsUpdateFrame = (WindowsUpdateFrame)frame;
                try {
                    responseData = windowsUpdateFrame.serialize().array();
                    this.getService().writeData(netPackage.getSession(), responseData);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            request = this.requestBuffers.get(netPackage.getSession());
            if (request == null) {
                Map<NetSession, HttpRequest> map = this.requestBuffers;
                synchronized (map) {
                    request = new HttpRequest();
                    request.setProtocol(this.httpProtocol);
                    this.requestBuffers.put(netPackage.getSession(), request);
                }
            }
            request.addData(netPackage.getPayload());
        }
        return request;
    }

    public synchronized void addContext(Context context) {
        boolean duplicated = false;
        for (Context ctx : this.contexts) {
            if (!ctx.getContextRegex().equals(context.getContextRegex())) continue;
            duplicated = true;
            break;
        }
        if (!duplicated) {
            this.contexts.add(context);
            Log.i(SystemProperties.get("hcjf.net.http.server.log.tag"), "Context added: [%s] %s", context.getClass().getName(), context.getContextRegex());
        } else {
            Log.w(SystemProperties.get("hcjf.net.http.server.log.tag"), "Duplicated context: [%s] %s", context.getClass().getName(), context.getContextRegex());
        }
    }

    protected ContextMatcher findContext(String contextName) {
        ContextMatcher result = null;
        for (Context context : this.contexts) {
            Matcher matcher = context.getPattern().matcher(contextName);
            if (!matcher.matches()) continue;
            result = new ContextMatcher(context, matcher);
            break;
        }
        return result;
    }

    @Override
    public void destroySession(NetSession session) {
        HttpSessionManager sessionManager = this.getSessionManager();
        if (sessionManager == null) {
            sessionManager = HttpSessionManager.DEFAULT;
        }
        sessionManager.destroySession((HttpSession)session);
    }

    @Override
    protected final void onRead(final HttpSession session, final HttpPackage payLoad, NetPackage netPackage) {
        if (session.getStream() == null && payLoad.isComplete()) {
            this.requestBuffers.remove(session);
            this.addDecoupledAction(new NetServiceConsumer.DecoupledAction(session){

                @Override
                public void onAction() {
                    HttpServer.this.processRequest(session, (HttpRequest)payLoad);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(HttpSession session, HttpRequest request) {
        HttpResponse response;
        long time;
        boolean connectionKeepAlive;
        block25: {
            session.setHttpVersion(request.getHttpVersion());
            connectionKeepAlive = false;
            time = System.currentTimeMillis();
            response = null;
            if (SystemProperties.getBoolean("hcjf.net.http.server.input.log.enabled").booleanValue()) {
                Log.in(SystemProperties.get("hcjf.net.http.server.log.tag"), "Request\r\n%s", request.toString());
            }
            try {
                if (session.isChecked()) {
                    block26: {
                        HttpHeader upgrade = request.getHeader("Upgrade");
                        if (upgrade != null && upgrade.getHeaderValue().equals("h2c")) {
                            session.setHttpVersion("HTTP/2.0");
                            HttpHeader connection = request.getHeader("Connection");
                            HttpHeader http2Settings = request.getHeader("HTTP2-Settings");
                            SettingsFrame settingsFrame = SettingsFrame.createDefaultSettingsFrame(0);
                            if (upgrade.getHeaderValue().trim().equalsIgnoreCase("h2c")) {
                                session.setStream(new Stream(1, new StreamSettings()));
                                response = new HttpResponse();
                                response.setResponseCode(HttpResponseCode.SWITCHING_PROTOCOLS);
                                response.addHeader(upgrade);
                                response.setBody(settingsFrame.serialize().array());
                                break block25;
                            }
                            throw new IllegalArgumentException("Unsupported upgrade connection " + upgrade.getHeaderValue());
                        }
                        ContextMatcher contextMatcher = this.findContext(request.getContext());
                        if (contextMatcher != null) {
                            Context context = contextMatcher.getContext();
                            HttpHeader originHeader = request.getHeader("Origin");
                            try {
                                request.setMatcher(contextMatcher.getMatcher());
                                Log.d(SystemProperties.get("hcjf.net.http.server.log.tag"), "Request context: %s", request.getContext());
                                if (originHeader != null && request.getMethod().equals((Object)HttpMethod.OPTIONS)) {
                                    response = context.onOptions(originHeader, this.accessControlMap);
                                } else {
                                    URL url;
                                    AccessControl accessControl;
                                    response = context.getTimeout() > 0L ? Service.call(() -> context.onContext(request), ServiceSession.getCurrentIdentity(), context.getTimeout()) : context.onContext(request);
                                    if (originHeader != null && (accessControl = HttpUtils.getAccessControl((url = new URL(originHeader.getHeaderValue())).getHost(), this.accessControlMap)) != null && !accessControl.getExposeHeaders().isEmpty()) {
                                        response.addHeader(new HttpHeader("Access-Control-Expose-Headers", Strings.join(accessControl.getExposeHeaders(), ",")));
                                    }
                                }
                                if (request.containsHeader("Connection") && request.getHeader("Connection").getHeaderValue().equalsIgnoreCase("Keep-Alive")) {
                                    Log.d(SystemProperties.get("hcjf.net.http.server.log.tag"), "Http connection keep alive", new Object[0]);
                                    connectionKeepAlive = true;
                                }
                                break block26;
                            }
                            catch (Throwable throwable) {
                                Log.e(SystemProperties.get("hcjf.net.http.server.log.tag"), "Exception on context %s", throwable, context.getContextRegex());
                                response = context.onError(request, throwable);
                                if (response == null) {
                                    response = this.createDefaultErrorResponse(throwable);
                                }
                                break block26;
                            }
                        }
                        response = this.onContextNotFound(request);
                    }
                    if (response == null) {
                        response = this.onUnresponsiveContext(request);
                    }
                    response.addHeader(new HttpHeader("Date", SystemProperties.getDateFormat("hcjf.net.http.response.date.header.format.value").format(new Date())));
                    response.addHeader(new HttpHeader("Server", SystemProperties.get("hcjf.net.http.server.name")));
                    break block25;
                }
                response = this.onNotCheckedSession(request);
            }
            catch (Throwable throwable) {
                response = this.createDefaultErrorResponse(throwable);
            }
        }
        response = this.addOriginHeader(request, response);
        try {
            response.setProtocol(this.httpProtocol);
            if (this.isContentLengthRequired(response)) {
                Integer length = response.getBody() == null ? 0 : response.getBody().length;
                response.addHeader(new HttpHeader("Content-Length", length.toString()));
            }
            if (response instanceof HttpPipelineResponse) {
                connectionKeepAlive = true;
                HttpResponse finalResponse = response;
                Service.run(() -> {
                    HttpPipelineResponse pipelineResponse = (HttpPipelineResponse)finalResponse;
                    pipelineResponse.onStart();
                    while (pipelineResponse.read() >= 0) {
                        try {
                            this.write(session, finalResponse, false);
                        }
                        catch (IOException e) {
                            Log.e(SystemProperties.get("hcjf.net.http.server.log.tag"), "Http server error", e, new Object[0]);
                            break;
                        }
                    }
                    pipelineResponse.onEnd();
                    this.disconnect(session, "Http request end.");
                }, ServiceSession.getCurrentIdentity());
            } else {
                this.write(session, response, false);
            }
            if (SystemProperties.getBoolean("hcjf.net.http.server.output.log.enabled").booleanValue()) {
                Log.out(SystemProperties.get("hcjf.net.http.server.log.tag"), "Response -> [Time: %d ms] \r\n%s", System.currentTimeMillis() - time, response.toString());
            }
        }
        catch (Throwable throwable) {
            Log.e(SystemProperties.get("hcjf.net.http.server.log.tag"), "Http server error", throwable, new Object[0]);
            connectionKeepAlive = false;
        }
        finally {
            if (!connectionKeepAlive && !session.getHttpVersion().equals("HTTP/2.0")) {
                this.disconnect(session, "Http request end.");
                Log.d(SystemProperties.get("hcjf.net.http.server.log.tag"), "Http connection closed by server.", new Object[0]);
            }
        }
    }

    private HttpResponse addOriginHeader(HttpRequest request, HttpResponse response) {
        HttpHeader originHeader = request.getHeader("Origin");
        if (originHeader != null) {
            response.addHeader(new HttpHeader("Access-Control-Allow-Origin", originHeader.getHeaderValue()));
        }
        return response;
    }

    private boolean isContentLengthRequired(HttpResponse response) {
        boolean result = false;
        if (!response.containsHeader("Content-Length") && SystemProperties.getBoolean("hcjf.net.http.enable.automatic.response.content.length").booleanValue() && !(response instanceof HttpPipelineResponse)) {
            result = true;
            try {
                List<String> skipCodes = SystemProperties.getList("hcjf.net.http.automatic.content.length.skip.codes");
                String responseCodeToString = response.getResponseCode().toString();
                if (skipCodes.contains(responseCodeToString)) {
                    result = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onCheckSessionError(HttpSession session, HttpPackage requestPayLoad, NetPackage netPackage, Throwable exception) {
        HttpRequest request = (HttpRequest)requestPayLoad;
        ContextMatcher contextMatcher = this.findContext(request.getContext());
        HttpResponse response = contextMatcher.getContext().onError(request, exception);
        String logTag = SystemProperties.get("hcjf.net.http.server.log.tag");
        try {
            this.write(session, response, false);
        }
        catch (Throwable throwable) {
            Log.e(logTag, "Http server error on check session error.", throwable, new Object[0]);
        }
        finally {
            this.disconnect(session, "Http request denied end.");
            Log.d(logTag, "Http connection closed by server.", new Object[0]);
        }
    }

    private HttpResponse createDefaultErrorResponse(Throwable throwable) {
        return Context.createDefaultErrorResponse(throwable);
    }

    protected HttpResponse onContextNotFound(HttpRequest request) {
        HttpResponse response = new HttpResponse();
        String body = "Context not found: " + request.getContext();
        response.setResponseCode(HttpResponseCode.NOT_FOUND);
        return Context.addDefaultResponseHeaders(response, body.getBytes());
    }

    protected HttpResponse onUnresponsiveContext(HttpRequest request) {
        HttpResponse response = new HttpResponse();
        String body = "Context unresponsive: " + request.getContext();
        response.setResponseCode(HttpResponseCode.NO_CONTENT);
        return Context.addDefaultResponseHeaders(response, body.getBytes());
    }

    protected HttpResponse onNotCheckedSession(HttpRequest request) {
        HttpResponse response = new HttpResponse();
        response.setResponseCode(HttpResponseCode.UNAUTHORIZED);
        response.addHeader(new HttpHeader("Connection", "Closed"));
        return response;
    }

    @Override
    protected final void onDisconnect(HttpSession session, NetPackage netPackage) {
        this.requestBuffers.remove(session);
    }

    @Override
    protected final void onWrite(HttpSession session, NetPackage netPackage) {
    }

    @Override
    protected void onStart() {
        Log.d(SystemProperties.get("hcjf.net.http.server.log.tag"), "Http server started, listening on port %d", this.getPort());
    }

    @Override
    public boolean isCreationTimeoutAvailable() {
        return false;
    }

    @Override
    protected void onStop() {
        Log.d(SystemProperties.get("hcjf.net.http.server.log.tag"), "Http server stopped.", new Object[0]);
    }

    public static class AccessControl {
        private static Integer MAX_AGE = 86400;
        private final String domain;
        private final Integer maxAge;
        private final List<String> allowMethods;
        private final List<String> allowHeaders;
        private final List<String> exposeHeaders;

        public AccessControl(String domain, Integer maxAge) {
            this.domain = domain;
            this.maxAge = maxAge <= 0 || maxAge > MAX_AGE ? MAX_AGE : maxAge;
            this.allowMethods = new ArrayList<String>();
            this.allowHeaders = new ArrayList<String>();
            this.exposeHeaders = new ArrayList<String>();
        }

        public AccessControl(String domain) {
            this(domain, MAX_AGE);
        }

        public String getDomain() {
            return this.domain;
        }

        public Integer getMaxAge() {
            return this.maxAge;
        }

        public List<String> getAllowMethods() {
            return Collections.unmodifiableList(this.allowMethods);
        }

        public List<String> getAllowHeaders() {
            return Collections.unmodifiableList(this.allowHeaders);
        }

        public List<String> getExposeHeaders() {
            return Collections.unmodifiableList(this.exposeHeaders);
        }

        public void addAllowMethod(String ... methods) {
            this.allowMethods.addAll(Arrays.asList(methods));
        }

        public void addAllowHeader(String ... headers) {
            this.allowHeaders.addAll(Arrays.asList(headers));
        }

        public void addExposeHeader(String ... headers) {
            this.exposeHeaders.addAll(Arrays.asList(headers));
        }
    }

    public static class ContextMatcher {
        private final Context context;
        private final Matcher matcher;

        public ContextMatcher(Context context, Matcher matcher) {
            this.context = context;
            this.matcher = matcher;
        }

        public Context getContext() {
            return this.context;
        }

        public Matcher getMatcher() {
            return this.matcher;
        }
    }
}

