/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http.http2;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import org.hcjf.io.net.http.http2.StreamSettings;
import org.hcjf.io.net.http.http2.frames.Http2Frame;
import org.hcjf.properties.SystemProperties;

public class Stream {
    private final Integer streamId;
    private final Integer headerTableSize;
    private final Boolean enablePush;
    private final Integer maxConcurrentStream;
    private final Integer initialWindowSize;
    private final Integer maxFrameSize;
    private final Integer maxHeaderListSize;
    private String http2Preface;
    private final Queue<Http2Frame> frames;
    private final ByteBuffer buffer;

    public Stream(Integer streamId, StreamSettings settings) {
        this.streamId = streamId;
        this.headerTableSize = settings.getHeaderTableSize();
        this.enablePush = settings.getEnablePush();
        this.maxConcurrentStream = settings.getMaxConcurrentStream();
        this.initialWindowSize = settings.getInitialWindowSize();
        this.maxFrameSize = settings.getMaxFrameSize();
        this.maxHeaderListSize = settings.getMaxHeaderListSize();
        this.frames = new ArrayBlockingQueue<Http2Frame>(SystemProperties.getInteger("hcjf.net.http.http2.stream.frames.queue.max.size"));
        this.buffer = ByteBuffer.allocate(this.maxFrameSize + Http2Frame.FRAME_HEADER_LENGTH);
    }

    public Integer getStreamId() {
        return this.streamId;
    }

    public Integer getHeaderTableSize() {
        return this.headerTableSize;
    }

    public Boolean getEnablePush() {
        return this.enablePush;
    }

    public Integer getMaxConcurrentStream() {
        return this.maxConcurrentStream;
    }

    public Integer getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public Integer getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public Integer getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    public String getHttpClientPreface() {
        return this.http2Preface;
    }

    public Collection<Http2Frame> getAndRemoveFrames() {
        ArrayList<Http2Frame> result = new ArrayList<Http2Frame>();
        while (!this.frames.isEmpty()) {
            result.add(this.frames.remove());
        }
        return result;
    }

    public void setHttpClientPreface(String http2Preface) {
        this.http2Preface = http2Preface;
    }

    public final synchronized void addData(byte[] data, int start) {
        block4: {
            block3: {
                Integer dataStart = start;
                Integer dataLength = data.length - start - (this.buffer.capacity() - this.buffer.position());
                if (dataLength < 0) {
                    dataLength = data.length - start;
                }
                this.buffer.put(data, dataStart, dataLength);
                this.buffer.flip();
                while (true) {
                    if (this.buffer.limit() < Http2Frame.FRAME_HEADER_LENGTH) {
                        continue;
                    }
                    Integer length = (this.buffer.get() & 0xF) << 16 | (this.buffer.get() & 0xFF) << 8 | this.buffer.get() & 0xFF;
                    Byte type = this.buffer.get();
                    Byte flags = this.buffer.get();
                    Integer id = (this.buffer.get() & 0xFFFFFF7F & 0xF) << 24 | (this.buffer.get() & 0xFF) << 16 | (this.buffer.get() & 0xFF) << 8 | this.buffer.get() & 0xFF;
                    if (this.buffer.limit() < length) break block3;
                    Object frame = Http2Frame.Builder.build(id, flags, length, type);
                    byte[] completeFrameData = new byte[length.intValue()];
                    this.buffer.get(completeFrameData);
                    ((Http2Frame)frame).setPayload(ByteBuffer.wrap(completeFrameData));
                    this.frames.add((Http2Frame)frame);
                    if (this.buffer.limit() - this.buffer.position() <= 0) break;
                    byte[] rest = new byte[this.buffer.limit() - (length + Http2Frame.FRAME_HEADER_LENGTH)];
                    this.buffer.get(rest);
                    this.buffer.clear();
                    this.buffer.put(rest);
                    this.buffer.flip();
                }
                this.buffer.clear();
                break block4;
            }
            this.buffer.position(0);
        }
    }
}

