/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.kubernetes;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1PodList;
import io.kubernetes.client.openapi.models.V1ServiceList;
import io.kubernetes.client.util.Config;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.hcjf.io.net.kubernetes.KubernetesSpyConsumer;
import org.hcjf.io.net.kubernetes.KubernetesSpyResource;
import org.hcjf.io.net.kubernetes.artifacts.KubernetesConfigMapResource;
import org.hcjf.io.net.kubernetes.artifacts.KubernetesCronJobResource;
import org.hcjf.io.net.kubernetes.artifacts.KubernetesDeploymentResource;
import org.hcjf.io.net.kubernetes.artifacts.KubernetesHorizontalPodAutoscalerResource;
import org.hcjf.io.net.kubernetes.artifacts.KubernetesJobResource;
import org.hcjf.layers.Layers;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.Service;
import org.hcjf.service.ServiceSession;

public final class KubernetesSpy
extends Service<KubernetesSpyConsumer> {
    private static final KubernetesSpy instance = new KubernetesSpy();
    private final Collection<KubernetesSpyConsumer> consumers = new ArrayList<KubernetesSpyConsumer>();

    private KubernetesSpy() {
        super(SystemProperties.get("hcjf.net.kubernetes.service.name"), 2);
    }

    public static KubernetesSpy getInstance() {
        return instance;
    }

    public static String getHostName() {
        return System.getenv("HOSTNAME");
    }

    @Override
    public void registerConsumer(KubernetesSpyConsumer consumer) {
        Objects.requireNonNull(consumer, "Unsupported null consumer");
        this.consumers.add(consumer);
    }

    @Override
    public void unregisterConsumer(KubernetesSpyConsumer consumer) {
        if (consumer != null) {
            this.consumers.remove(consumer);
        }
    }

    @Override
    protected void init() {
        KubernetesSpy.run(new KubernetesPodSpyTask(), ServiceSession.getSystemSession());
    }

    static {
        Layers.publishLayer(KubernetesSpyResource.class);
        Layers.publishLayer(KubernetesDeploymentResource.class);
        Layers.publishLayer(KubernetesJobResource.class);
        Layers.publishLayer(KubernetesCronJobResource.class);
        Layers.publishLayer(KubernetesConfigMapResource.class);
        Layers.publishLayer(KubernetesHorizontalPodAutoscalerResource.class);
    }

    private class KubernetesPodSpyTask
    implements Runnable {
        private KubernetesPodSpyTask() {
        }

        @Override
        public void run() {
            String namespace = null;
            ApiClient client = null;
            try {
                client = Config.fromCluster();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Configuration.setDefaultApiClient((ApiClient)client);
            CoreV1Api api = new CoreV1Api();
            try {
                namespace = new String(Files.readAllBytes(SystemProperties.getPath("hcjf.net.kubernetes.namespace.file.path"))).trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    V1PodList podList = api.listNamespacedPod(namespace, null, null, null, null, null, null, null, null, null, Boolean.valueOf(false));
                    for (KubernetesSpyConsumer consumer : KubernetesSpy.this.consumers) {
                        KubernetesSpy.this.fork(() -> consumer.updatePods(podList));
                    }
                }
                catch (Exception ex) {
                    Log.w(SystemProperties.get("hcjf.net.kubernetes.log.tag"), "Unable to list pods", ex, new Object[0]);
                }
                try {
                    V1ServiceList serviceList = api.listNamespacedService(namespace, null, null, null, null, null, null, null, null, null, Boolean.valueOf(false));
                    for (KubernetesSpyConsumer consumer : KubernetesSpy.this.consumers) {
                        KubernetesSpy.this.fork(() -> consumer.updateServices(serviceList));
                    }
                }
                catch (Exception ex) {
                    Log.w(SystemProperties.get("hcjf.net.kubernetes.log.tag"), "Unable to list pods", ex, new Object[0]);
                }
                try {
                    Thread.sleep(SystemProperties.getLong("hcjf.net.kubernetes.task.sleep.time"));
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            Log.d(SystemProperties.get("hcjf.net.kubernetes.log.tag"), "Kubernetes spy task finish", new Object[0]);
        }
    }
}

