/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.kubernetes.artifacts;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.AutoscalingV2beta2Api;
import io.kubernetes.client.openapi.apis.BatchV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.util.Config;
import io.kubernetes.client.util.Yaml;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.layers.Layer;
import org.hcjf.layers.crud.CreateLayerInterface;
import org.hcjf.properties.SystemProperties;
import org.hcjf.utils.Introspection;

public abstract class KubernetesArtifactResource<T>
extends Layer
implements CreateLayerInterface<Map<String, Object>> {
    private final ApiClient client;
    private final CoreV1Api coreApi;
    private final AppsV1Api appsApi;
    private final BatchV1Api batchApi;
    private final AutoscalingV2beta2Api autoscalingV2beta2Api;

    public KubernetesArtifactResource() {
        try {
            this.client = Config.fromCluster();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create k8s client", e);
        }
        Configuration.setDefaultApiClient((ApiClient)this.client);
        this.coreApi = new CoreV1Api();
        this.appsApi = new AppsV1Api();
        this.batchApi = new BatchV1Api();
        this.autoscalingV2beta2Api = new AutoscalingV2beta2Api();
    }

    protected abstract Class<T> getArtifactType();

    protected abstract void createArtifact(T var1, String var2, String var3, String var4, String var5);

    protected abstract void updateArtifact(String var1, T var2, String var3, String var4, String var5, String var6);

    protected abstract boolean isCreated(String var1);

    protected final CoreV1Api getCoreApi() {
        return this.coreApi;
    }

    protected final AppsV1Api getAppsApi() {
        return this.appsApi;
    }

    protected final BatchV1Api getBatchApi() {
        return this.batchApi;
    }

    protected final AutoscalingV2beta2Api getAutoscalingV2beta2Api() {
        return this.autoscalingV2beta2Api;
    }

    protected final ApiClient getClient() {
        return this.client;
    }

    protected final String getNamespace() {
        return SystemProperties.get("hcjf.cloud.orchestrator.kubernetes.namespace");
    }

    @Override
    public Map<String, Object> create(Map<String, Object> artifact) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String yamlBody = (String)Introspection.resolve(artifact, "yaml");
        if (yamlBody == null) {
            throw new HCJFRuntimeException("The field 'yaml' is required", new Object[0]);
        }
        List parameters = (List)Introspection.resolve(artifact, "parameters");
        if (parameters != null && parameters.size() > 0) {
            yamlBody = String.format(yamlBody, parameters.toArray());
        }
        Object artifactInstance = Yaml.loadAs((String)yamlBody, this.getArtifactType());
        Boolean forceUpdate = (Boolean)Introspection.resolve(artifact, "forceUpdate");
        String name = (String)Introspection.resolve(artifact, "name");
        String pretty = (String)Introspection.resolve(artifact, "pretty");
        String dryRun = (String)Introspection.resolve(artifact, "dryRun");
        String fieldManager = (String)Introspection.resolve(artifact, "fieldManager");
        String fieldValidation = (String)Introspection.resolve(artifact, "fieldValidation");
        if (name != null && this.isCreated(name)) {
            if (forceUpdate != null && forceUpdate.booleanValue()) {
                this.updateArtifact(name, artifactInstance, pretty, dryRun, fieldManager, fieldValidation);
            }
        } else {
            this.createArtifact(artifactInstance, pretty, dryRun, fieldManager, fieldValidation);
        }
        return response;
    }

    public static final class Fields {
        public static final String NAME = "name";
        public static final String YAML = "yaml";
        public static final String PARAMETERS = "parameters";
        public static final String FORCE_UPDATE = "forceUpdate";
        public static final String PRETTY = "pretty";
        public static final String DRY_RUN = "dryRun";
        public static final String FIELD_MANAGER = "fieldManager";
        public static final String FIELD_VALIDATION = "fieldValidation";
    }
}

