/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.kubernetes.artifacts;

import io.kubernetes.client.openapi.models.V1ConfigMap;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.io.net.kubernetes.artifacts.KubernetesArtifactResource;

public class KubernetesConfigMapResource
extends KubernetesArtifactResource<V1ConfigMap> {
    public static final String NAME = "system_k8s_config_map";

    @Override
    public String getImplName() {
        return NAME;
    }

    @Override
    protected Class<V1ConfigMap> getArtifactType() {
        return V1ConfigMap.class;
    }

    @Override
    protected void createArtifact(V1ConfigMap artifact, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        try {
            this.getCoreApi().createNamespacedConfigMap(this.getNamespace(), artifact, pretty, dryRun, fieldManager, fieldValidation);
        }
        catch (Exception ex) {
            throw new HCJFRuntimeException("K8s config map creation fail", (Throwable)ex, new Object[0]);
        }
    }

    @Override
    protected void updateArtifact(String name, V1ConfigMap artifact, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        try {
            this.getCoreApi().replaceNamespacedConfigMap(name, this.getNamespace(), artifact, pretty, dryRun, fieldManager, fieldValidation);
        }
        catch (Exception ex) {
            throw new HCJFRuntimeException("K8s config map creation fail", (Throwable)ex, new Object[0]);
        }
    }

    @Override
    protected boolean isCreated(String manifestName) {
        boolean result = false;
        try {
            V1ConfigMap configMap = this.getCoreApi().readNamespacedConfigMap(manifestName, this.getNamespace(), null);
            if (configMap != null) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

