/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.kubernetes.artifacts;

import io.kubernetes.client.openapi.models.V1CronJob;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.io.net.kubernetes.artifacts.KubernetesArtifactResource;

public class KubernetesCronJobResource
extends KubernetesArtifactResource<V1CronJob> {
    public static final String NAME = "system_k8s_cron_job";

    @Override
    public String getImplName() {
        return NAME;
    }

    @Override
    protected Class<V1CronJob> getArtifactType() {
        return V1CronJob.class;
    }

    @Override
    protected void createArtifact(V1CronJob artifact, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        try {
            this.getBatchApi().createNamespacedCronJob(this.getNamespace(), artifact, pretty, dryRun, fieldManager, fieldValidation);
        }
        catch (Exception ex) {
            throw new HCJFRuntimeException("K8s cron job creation fail", (Throwable)ex, new Object[0]);
        }
    }

    @Override
    protected void updateArtifact(String name, V1CronJob artifact, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        try {
            this.getBatchApi().replaceNamespacedCronJob(name, this.getNamespace(), artifact, pretty, dryRun, fieldManager, fieldValidation);
        }
        catch (Exception ex) {
            throw new HCJFRuntimeException("K8s cron job creation fail", (Throwable)ex, new Object[0]);
        }
    }

    @Override
    protected boolean isCreated(String manifestName) {
        boolean result = false;
        try {
            V1CronJob cronJob = this.getBatchApi().readNamespacedCronJob(manifestName, this.getNamespace(), null);
            if (cronJob != null) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

