/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.kubernetes.artifacts;

import io.kubernetes.client.openapi.models.V1Deployment;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.io.net.kubernetes.artifacts.KubernetesArtifactResource;

public class KubernetesDeploymentResource
extends KubernetesArtifactResource<V1Deployment> {
    public static final String NAME = "system_k8s_deployment";

    @Override
    public String getImplName() {
        return NAME;
    }

    @Override
    protected Class<V1Deployment> getArtifactType() {
        return V1Deployment.class;
    }

    @Override
    protected void createArtifact(V1Deployment artifact, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        try {
            this.getAppsApi().createNamespacedDeployment(this.getNamespace(), artifact, pretty, dryRun, fieldManager, fieldValidation);
        }
        catch (Exception ex) {
            throw new HCJFRuntimeException("K8s deployment creation fail", (Throwable)ex, new Object[0]);
        }
    }

    @Override
    protected void updateArtifact(String name, V1Deployment artifact, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        try {
            this.getAppsApi().replaceNamespacedDeployment(name, this.getNamespace(), artifact, pretty, dryRun, fieldManager, fieldValidation);
        }
        catch (Exception ex) {
            throw new HCJFRuntimeException("K8s deployment creation fail", (Throwable)ex, new Object[0]);
        }
    }

    @Override
    protected boolean isCreated(String manifestName) {
        boolean result = false;
        try {
            V1Deployment deployment = this.getAppsApi().readNamespacedDeployment(manifestName, this.getNamespace(), null);
            if (deployment != null) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

