/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.kubernetes.artifacts;

import io.kubernetes.client.openapi.models.V2beta2HorizontalPodAutoscaler;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.io.net.kubernetes.artifacts.KubernetesArtifactResource;

public class KubernetesHorizontalPodAutoscalerResource
extends KubernetesArtifactResource<V2beta2HorizontalPodAutoscaler> {
    public static final String NAME = "system_k8s_hpa";

    @Override
    public String getImplName() {
        return NAME;
    }

    @Override
    protected Class<V2beta2HorizontalPodAutoscaler> getArtifactType() {
        return V2beta2HorizontalPodAutoscaler.class;
    }

    @Override
    protected void createArtifact(V2beta2HorizontalPodAutoscaler artifact, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        try {
            this.getAutoscalingV2beta2Api().createNamespacedHorizontalPodAutoscaler(this.getNamespace(), artifact, pretty, dryRun, fieldManager, fieldValidation);
        }
        catch (Exception ex) {
            throw new HCJFRuntimeException("K8s horizontal pod autoscaler creation fail", (Throwable)ex, new Object[0]);
        }
    }

    @Override
    protected void updateArtifact(String name, V2beta2HorizontalPodAutoscaler artifact, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        try {
            this.getAutoscalingV2beta2Api().replaceNamespacedHorizontalPodAutoscaler(name, this.getNamespace(), artifact, pretty, dryRun, fieldManager, fieldValidation);
        }
        catch (Exception ex) {
            throw new HCJFRuntimeException("K8s cron job creation fail", (Throwable)ex, new Object[0]);
        }
    }

    @Override
    protected boolean isCreated(String manifestName) {
        boolean result = false;
        try {
            V2beta2HorizontalPodAutoscaler horizontalPodAutoscaler = this.getAutoscalingV2beta2Api().readNamespacedHorizontalPodAutoscaler(manifestName, this.getNamespace(), null);
            if (horizontalPodAutoscaler != null) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

