/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.kubernetes.artifacts;

import io.kubernetes.client.openapi.models.V1Job;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.io.net.kubernetes.artifacts.KubernetesArtifactResource;

public class KubernetesJobResource
extends KubernetesArtifactResource<V1Job> {
    public static final String NAME = "system_k8s_job";

    @Override
    public String getImplName() {
        return NAME;
    }

    @Override
    protected Class<V1Job> getArtifactType() {
        return V1Job.class;
    }

    @Override
    protected void createArtifact(V1Job artifact, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        try {
            this.getBatchApi().createNamespacedJob(this.getNamespace(), artifact, pretty, dryRun, fieldManager, fieldValidation);
        }
        catch (Exception ex) {
            throw new HCJFRuntimeException("K8s job creation fail", (Throwable)ex, new Object[0]);
        }
    }

    @Override
    protected void updateArtifact(String name, V1Job artifact, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        try {
            this.getBatchApi().replaceNamespacedJob(name, this.getNamespace(), artifact, pretty, dryRun, fieldManager, fieldValidation);
        }
        catch (Exception ex) {
            throw new HCJFRuntimeException("K8s job creation fail", (Throwable)ex, new Object[0]);
        }
    }

    @Override
    protected boolean isCreated(String manifestName) {
        boolean result = false;
        try {
            V1Job job = this.getBatchApi().readNamespacedJob(manifestName, this.getNamespace(), null);
            if (job != null) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

