/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.kubernetes.artifacts;

import io.kubernetes.client.openapi.models.V1Service;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.io.net.kubernetes.artifacts.KubernetesArtifactResource;

public class KubernetesServiceResource
extends KubernetesArtifactResource<V1Service> {
    public static final String NAME = "system_k8s_service";

    @Override
    public String getImplName() {
        return NAME;
    }

    @Override
    protected Class<V1Service> getArtifactType() {
        return V1Service.class;
    }

    @Override
    protected void createArtifact(V1Service artifact, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        try {
            this.getCoreApi().createNamespacedService(this.getNamespace(), artifact, pretty, dryRun, fieldManager, fieldValidation);
        }
        catch (Exception ex) {
            throw new HCJFRuntimeException("K8s service creation fail", (Throwable)ex, new Object[0]);
        }
    }

    @Override
    protected void updateArtifact(String name, V1Service artifact, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        try {
            this.getCoreApi().replaceNamespacedService(name, this.getNamespace(), artifact, pretty, dryRun, fieldManager, fieldValidation);
        }
        catch (Exception ex) {
            throw new HCJFRuntimeException("K8s service creation fail", (Throwable)ex, new Object[0]);
        }
    }

    @Override
    protected boolean isCreated(String manifestName) {
        boolean result = false;
        try {
            V1Service service = this.getCoreApi().readNamespacedService(manifestName, this.getNamespace(), null);
            if (service != null) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

