/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.messages;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.hcjf.bson.BsonCollection;
import org.hcjf.bson.BsonDecoder;
import org.hcjf.bson.BsonDocument;
import org.hcjf.bson.BsonEncoder;
import org.hcjf.io.net.NetPackage;
import org.hcjf.io.net.NetServer;
import org.hcjf.io.net.NetService;
import org.hcjf.io.net.NetServiceConsumer;
import org.hcjf.io.net.NetSession;
import org.hcjf.io.net.messages.EncryptedMessage;
import org.hcjf.io.net.messages.Message;
import org.hcjf.io.net.messages.MessageBuffer;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.ServiceSession;
import org.hcjf.utils.Cryptography;
import org.hcjf.utils.bson.BsonParcelable;

public abstract class MessagesServer<S extends NetSession>
extends NetServer<S, MessageBuffer> {
    private final Map<S, MessageBuffer> buffersBySession = new HashMap<S, MessageBuffer>();
    private final Cryptography cryptography;

    public MessagesServer(Integer port, NetService.TransportLayerProtocol protocol, boolean multiSession, boolean disconnectAndRemove) {
        this(port, protocol, multiSession, disconnectAndRemove, null);
    }

    public MessagesServer(Integer port, NetService.TransportLayerProtocol protocol, boolean multiSession, boolean disconnectAndRemove, Cryptography cryptography) {
        super(port, protocol, multiSession, disconnectAndRemove);
        this.cryptography = cryptography;
        if (SystemProperties.getBoolean("hcjf.net.messages.server.decoupled.io.action").booleanValue()) {
            this.decoupleIoAction(SystemProperties.getInteger("hcjf.net.messages.server.io.queue.size"), SystemProperties.getInteger("hcjf.net.messages.server.io.workers"));
        }
    }

    public final boolean isEncrypted() {
        return this.cryptography != null;
    }

    @Override
    protected final byte[] encode(MessageBuffer payLoad) {
        return payLoad.getBytes();
    }

    @Override
    protected final synchronized MessageBuffer decode(NetPackage netPackage) {
        MessageBuffer messageBuffer = this.buffersBySession.remove(netPackage.getSession());
        if (messageBuffer == null) {
            messageBuffer = new MessageBuffer();
        }
        messageBuffer.append(netPackage.getPayload());
        if (messageBuffer.isComplete()) {
            this.buffersBySession.put(netPackage.getSession(), messageBuffer.getLeftover());
        } else {
            this.buffersBySession.put(netPackage.getSession(), messageBuffer);
        }
        return messageBuffer;
    }

    public final void send(S session, Message message) throws IOException {
        MessageBuffer buffer = new MessageBuffer();
        buffer.append(this.isEncrypted() ? this.encrypt(message) : message);
        this.write(session, buffer, false);
    }

    @Override
    public void destroySession(NetSession session) {
        this.buffersBySession.remove(session);
    }

    @Override
    protected final void onRead(S session, MessageBuffer payLoad, NetPackage netPackage) {
        if (payLoad.isComplete()) {
            for (Message message : payLoad.getMessages()) {
                this.addDecoupledAction(new NetServiceConsumer.DecoupledAction((ServiceSession)session, (NetSession)session, message){
                    final /* synthetic */ NetSession val$session;
                    final /* synthetic */ Message val$message;
                    {
                        this.val$session = netSession;
                        this.val$message = message;
                        super(serviceSession);
                    }

                    @Override
                    public void onAction() {
                        MessagesServer.this.onRead(this.val$session, MessagesServer.this.isEncrypted() ? MessagesServer.this.decrypt((EncryptedMessage)this.val$message) : this.val$message);
                    }
                });
            }
        }
    }

    protected EncryptedMessage encrypt(Message message) {
        EncryptedMessage encryptedMessage = new EncryptedMessage();
        encryptedMessage.setId(message.getId());
        encryptedMessage.setSessionId(message.getSessionId());
        encryptedMessage.setTimestamp(message.getTimestamp());
        encryptedMessage.setEncrypedData(this.cryptography.encrypt(BsonEncoder.encode((BsonCollection)message.toBson())));
        return encryptedMessage;
    }

    protected Message decrypt(EncryptedMessage encryptedMessage) {
        BsonDocument document = BsonDecoder.decode((byte[])this.cryptography.decrypt(encryptedMessage.getEncrypedData()));
        return (Message)BsonParcelable.Builder.create(document);
    }

    protected abstract void onRead(S var1, Message var2);
}

