/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.io.net.ssl.SslPeer;

public class SslClient
extends SslPeer {
    private final String protocol;
    private final String remoteAddress;
    private final Integer port;
    private SSLEngine engine;
    private ByteBuffer myAppData;
    private ByteBuffer myNetData;
    private ByteBuffer peerAppData;
    private ByteBuffer peerNetData;
    private ByteBuffer previousNetData;

    @Override
    public ByteBuffer getMyAppData(SocketChannel socketChannel) {
        return this.myAppData;
    }

    @Override
    public void setMyAppData(SocketChannel socketChannel, ByteBuffer myAppData) {
        this.myAppData = myAppData;
    }

    @Override
    public ByteBuffer getMyNetData(SocketChannel socketChannel) {
        return this.myNetData;
    }

    @Override
    public void setMyNetData(SocketChannel socketChannel, ByteBuffer myNetData) {
        this.myNetData = myNetData;
    }

    @Override
    public ByteBuffer getPeerAppData(SocketChannel socketChannel) {
        return this.peerAppData;
    }

    @Override
    public void setPeerAppData(SocketChannel socketChannel, ByteBuffer peerAppData) {
        this.peerAppData = peerAppData;
    }

    @Override
    public ByteBuffer getPeerNetData(SocketChannel socketChannel) {
        return this.peerNetData;
    }

    @Override
    public void setPeerNetData(SocketChannel socketChannel, ByteBuffer peerNetData) {
        this.peerNetData = peerNetData;
    }

    public SslClient(String protocol, String remoteAddress, int port) throws Exception {
        this.protocol = protocol;
        this.remoteAddress = remoteAddress;
        this.port = port;
    }

    @Override
    protected synchronized SSLEngine getSslEngine(SocketChannel socketChannel) {
        try {
            if (this.engine == null) {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sslContext = SSLContext.getInstance(this.protocol);
                sslContext.init(null, trustAllCerts, new SecureRandom());
                this.engine = sslContext.createSSLEngine(this.remoteAddress, this.port);
                this.engine.setUseClientMode(true);
                SSLSession session = this.engine.getSession();
                this.setMyAppData(socketChannel, ByteBuffer.allocate(1000000));
                this.setMyNetData(socketChannel, ByteBuffer.allocate(1000000));
                this.setPeerAppData(socketChannel, ByteBuffer.allocate(1000000));
                this.setPeerNetData(socketChannel, ByteBuffer.allocate(1000000));
            }
            return this.engine;
        }
        catch (Exception ex) {
            throw new HCJFRuntimeException("SSL Engine creation fail", (Throwable)ex, new Object[0]);
        }
    }

    @Override
    public synchronized void write(SocketChannel socketChannel, ByteBuffer message) throws IOException {
        this.getMyAppData(socketChannel).clear();
        this.getMyAppData(socketChannel).put(message);
        this.getMyAppData(socketChannel).flip();
        block6: while (this.getMyAppData(socketChannel).hasRemaining()) {
            this.getMyNetData(socketChannel).clear();
            SSLEngineResult result = this.engine.wrap(this.getMyAppData(socketChannel), this.getMyNetData(socketChannel));
            switch (result.getStatus()) {
                case OK: {
                    this.getMyNetData(socketChannel).flip();
                    while (this.getMyNetData(socketChannel).hasRemaining()) {
                        socketChannel.write(this.getMyNetData(socketChannel));
                    }
                    continue block6;
                }
                case BUFFER_OVERFLOW: {
                    this.setMyNetData(socketChannel, this.enlargePacketBuffer(this.engine, this.getMyNetData(socketChannel)));
                    continue block6;
                }
                case BUFFER_UNDERFLOW: {
                    throw new SSLException("Buffer underflow occurs after a wrap");
                }
                case CLOSED: {
                    return;
                }
            }
            throw new IllegalStateException("Invalid SSL status: " + String.valueOf((Object)result.getStatus()));
        }
    }

    @Override
    public synchronized int read(SocketChannel socketChannel, ByteBuffer buffer) throws Exception {
        boolean exitReadLoop = false;
        int bytesRead = 0;
        while (!exitReadLoop) {
            try {
                System.out.println("Peer net buffer remaining at begin: " + this.getPeerNetData(socketChannel).remaining());
                this.getPeerNetData(socketChannel).clear();
                if (this.previousNetData != null) {
                    this.getPeerNetData(socketChannel).put(this.previousNetData);
                }
                if ((bytesRead = socketChannel.read(this.getPeerNetData(socketChannel))) <= 0) break;
                this.getPeerNetData(socketChannel).flip();
                block9: while (this.getPeerNetData(socketChannel).hasRemaining()) {
                    this.getPeerAppData(socketChannel).clear();
                    SSLEngineResult result = this.engine.unwrap(this.getPeerNetData(socketChannel), this.getPeerAppData(socketChannel));
                    switch (result.getStatus()) {
                        case OK: {
                            System.out.println("SSL Ok");
                            this.getPeerAppData(socketChannel).flip();
                            this.getPeerAppData(socketChannel).limit();
                            buffer.put(this.getPeerAppData(socketChannel));
                            this.previousNetData = null;
                            exitReadLoop = true;
                            continue block9;
                        }
                        case BUFFER_OVERFLOW: {
                            System.out.println("SSL Overflow");
                            this.setPeerAppData(socketChannel, this.enlargeApplicationBuffer(this.engine, this.getPeerAppData(socketChannel)));
                            continue block9;
                        }
                        case BUFFER_UNDERFLOW: {
                            System.out.println("SSL Underflow");
                            byte[] previous = new byte[this.getPeerNetData(socketChannel).remaining()];
                            this.getPeerNetData(socketChannel).get(previous);
                            this.previousNetData = ByteBuffer.wrap(previous);
                            exitReadLoop = true;
                            continue block9;
                        }
                        case CLOSED: {
                            bytesRead = -1;
                            continue block9;
                        }
                    }
                    throw new IllegalStateException("Invalid SSL status: " + String.valueOf((Object)result.getStatus()));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        System.out.println("Read loop ends");
        return bytesRead;
    }
}

