/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.ssl;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.log.Log;
import org.hcjf.service.Service;
import org.hcjf.service.ServiceSession;

public abstract class SslPeer {
    public abstract ByteBuffer getMyAppData(SocketChannel var1);

    public abstract void setMyAppData(SocketChannel var1, ByteBuffer var2);

    public abstract ByteBuffer getMyNetData(SocketChannel var1);

    public abstract void setMyNetData(SocketChannel var1, ByteBuffer var2);

    public abstract ByteBuffer getPeerAppData(SocketChannel var1);

    public abstract void setPeerAppData(SocketChannel var1, ByteBuffer var2);

    public abstract ByteBuffer getPeerNetData(SocketChannel var1);

    public abstract void setPeerNetData(SocketChannel var1, ByteBuffer var2);

    public abstract int read(SocketChannel var1, ByteBuffer var2) throws Exception;

    public abstract void write(SocketChannel var1, ByteBuffer var2) throws Exception;

    protected abstract SSLEngine getSslEngine(SocketChannel var1);

    public final boolean init(SocketChannel socketChannel) {
        try {
            this.getSslEngine(socketChannel).beginHandshake();
            return this.doHandshake(socketChannel, this.getSslEngine(socketChannel));
        }
        catch (Exception ex) {
            throw new HCJFRuntimeException("Ssl peer init fail", (Throwable)ex, new Object[0]);
        }
    }

    protected boolean doHandshake(SocketChannel socketChannel, SSLEngine engine) throws IOException {
        Log.i("SSL", "About to do handshake...", new Object[0]);
        int appBufferSize = engine.getSession().getApplicationBufferSize();
        ByteBuffer myAppData = ByteBuffer.allocate(appBufferSize);
        ByteBuffer peerAppData = ByteBuffer.allocate(appBufferSize);
        this.getMyNetData(socketChannel).clear();
        this.getPeerNetData(socketChannel).clear();
        SSLEngineResult.HandshakeStatus handshakeStatus = engine.getHandshakeStatus();
        block26: while (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            switch (handshakeStatus) {
                case NEED_UNWRAP: {
                    SSLEngineResult result;
                    if (socketChannel.read(this.getPeerNetData(socketChannel)) < 0) {
                        if (engine.isInboundDone() && engine.isOutboundDone()) {
                            return false;
                        }
                        try {
                            engine.closeInbound();
                        }
                        catch (SSLException e) {
                            Log.i("SSL", "This engine was forced to close inbound, without having received the proper SSL/TLS close notification message from the peer, due to end of stream.", new Object[0]);
                        }
                        engine.closeOutbound();
                        handshakeStatus = engine.getHandshakeStatus();
                        continue block26;
                    }
                    this.getPeerNetData(socketChannel).flip();
                    try {
                        result = engine.unwrap(this.getPeerNetData(socketChannel), peerAppData);
                        this.getPeerNetData(socketChannel).compact();
                        handshakeStatus = result.getHandshakeStatus();
                    }
                    catch (SSLException sslException) {
                        Log.i("SSL", "A problem was encountered while processing the data that caused the SSLEngine to abort. Will try to properly close connection...", new Object[0]);
                        engine.closeOutbound();
                        handshakeStatus = engine.getHandshakeStatus();
                        continue block26;
                    }
                    switch (result.getStatus()) {
                        case OK: {
                            continue block26;
                        }
                        case BUFFER_OVERFLOW: {
                            peerAppData = this.enlargeApplicationBuffer(engine, peerAppData);
                            continue block26;
                        }
                        case BUFFER_UNDERFLOW: {
                            this.setPeerNetData(socketChannel, this.handleBufferUnderflow(engine, this.getPeerNetData(socketChannel)));
                            continue block26;
                        }
                        case CLOSED: {
                            if (engine.isOutboundDone()) {
                                return false;
                            }
                            engine.closeOutbound();
                            handshakeStatus = engine.getHandshakeStatus();
                            continue block26;
                        }
                    }
                    throw new IllegalStateException("Invalid SSL status: " + String.valueOf((Object)result.getStatus()));
                }
                case NEED_WRAP: {
                    SSLEngineResult result;
                    this.getMyNetData(socketChannel).clear();
                    try {
                        result = engine.wrap(myAppData, this.getMyNetData(socketChannel));
                        handshakeStatus = result.getHandshakeStatus();
                    }
                    catch (SSLException ex) {
                        Log.e("SSL", "A problem was encountered while processing the data that caused the SSLEngine to abort. Will try to properly close connection...", ex, new Object[0]);
                        engine.closeOutbound();
                        handshakeStatus = engine.getHandshakeStatus();
                        continue block26;
                    }
                    switch (result.getStatus()) {
                        case OK: {
                            this.getMyNetData(socketChannel).flip();
                            while (this.getMyNetData(socketChannel).hasRemaining()) {
                                socketChannel.write(this.getMyNetData(socketChannel));
                            }
                            continue block26;
                        }
                        case BUFFER_OVERFLOW: {
                            this.setMyNetData(socketChannel, this.enlargePacketBuffer(engine, this.getMyNetData(socketChannel)));
                            continue block26;
                        }
                        case BUFFER_UNDERFLOW: {
                            throw new SSLException("Buffer underflow occurred after a wrap. I don't think we should ever get here.");
                        }
                        case CLOSED: {
                            try {
                                this.getMyNetData(socketChannel).flip();
                                while (this.getMyNetData(socketChannel).hasRemaining()) {
                                    socketChannel.write(this.getMyNetData(socketChannel));
                                }
                                this.getPeerNetData(socketChannel).clear();
                            }
                            catch (Exception e) {
                                Log.w("SSL", "Failed to send server's CLOSE message due to socket channel's failure.", new Object[0]);
                                handshakeStatus = engine.getHandshakeStatus();
                            }
                            continue block26;
                        }
                    }
                    throw new IllegalStateException("Invalid SSL status: " + String.valueOf((Object)result.getStatus()));
                }
                case NEED_TASK: {
                    Runnable task;
                    while ((task = engine.getDelegatedTask()) != null) {
                        Service.run(task, ServiceSession.getSystemSession());
                    }
                    handshakeStatus = engine.getHandshakeStatus();
                    continue block26;
                }
                case FINISHED: 
                case NOT_HANDSHAKING: {
                    Log.w("SSL", "Not handshaking", new Object[0]);
                    continue block26;
                }
            }
            throw new IllegalStateException("Invalid SSL status: " + String.valueOf((Object)handshakeStatus));
        }
        Log.i("SSL", "Return handshake", new Object[0]);
        return true;
    }

    protected ByteBuffer enlargePacketBuffer(SSLEngine engine, ByteBuffer buffer) {
        return this.enlargeBuffer(buffer, engine.getSession().getPacketBufferSize());
    }

    protected ByteBuffer enlargeApplicationBuffer(SSLEngine engine, ByteBuffer buffer) {
        return this.enlargeBuffer(buffer, engine.getSession().getApplicationBufferSize());
    }

    protected ByteBuffer enlargeBuffer(ByteBuffer buffer, int sessionProposedCapacity) {
        buffer = sessionProposedCapacity > buffer.capacity() ? ByteBuffer.allocate(10000) : ByteBuffer.allocate(buffer.capacity() * 2);
        return buffer;
    }

    protected ByteBuffer handleBufferUnderflow(SSLEngine engine, ByteBuffer buffer) {
        ByteBuffer replaceBuffer = this.enlargePacketBuffer(engine, buffer);
        buffer.flip();
        replaceBuffer.put(buffer);
        return replaceBuffer;
    }

    public void close(SocketChannel socketChannel) throws IOException {
        this.getSslEngine(socketChannel).closeOutbound();
        this.doHandshake(socketChannel, this.getSslEngine(socketChannel));
    }

    protected KeyManager[] createKeyManagers(String filepath, String keystorePassword, String keyPassword) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        try (FileInputStream keyStoreIS = new FileInputStream(filepath);){
            keyStore.load(keyStoreIS, keystorePassword.toCharArray());
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, keyPassword.toCharArray());
        return kmf.getKeyManagers();
    }

    protected TrustManager[] createTrustManagers(String filepath, String keystorePassword) throws Exception {
        KeyStore trustStore = KeyStore.getInstance("JKS");
        try (FileInputStream trustStoreIS = new FileInputStream(filepath);){
            trustStore.load(trustStoreIS, keystorePassword.toCharArray());
        }
        TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustFactory.init(trustStore);
        return trustFactory.getTrustManagers();
    }
}

