/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.hcjf.io.net.ssl.SslPeer;
import org.hcjf.log.Log;

public class SslServer
extends SslPeer {
    private final SSLContext context;
    private final Map<SocketChannel, SSLEngine> engineBySocket;
    private final Map<SocketChannel, ByteBuffer> myAppDataMap;
    private final Map<SocketChannel, ByteBuffer> myNetDataMap;
    private final Map<SocketChannel, ByteBuffer> peerAppDataMap;
    private final Map<SocketChannel, ByteBuffer> peerNetDataMap;

    public SslServer(String protocol) throws Exception {
        this.context = SSLContext.getInstance(protocol);
        this.context.init(this.createKeyManagers("/home/javaito/Git/HolandaCatalinaFw/src/main/resources/org/hcjf/io/net/https/client.jks", "storepass", "keypass"), this.createTrustManagers("/home/javaito/Git/HolandaCatalinaFw/src/main/resources/org/hcjf/io/net/https/trustedCerts.jks", "storepass"), new SecureRandom());
        this.engineBySocket = new HashMap<SocketChannel, SSLEngine>();
        this.myAppDataMap = new HashMap<SocketChannel, ByteBuffer>();
        this.myNetDataMap = new HashMap<SocketChannel, ByteBuffer>();
        this.peerAppDataMap = new HashMap<SocketChannel, ByteBuffer>();
        this.peerNetDataMap = new HashMap<SocketChannel, ByteBuffer>();
    }

    @Override
    public void close(SocketChannel socketChannel) throws IOException {
        super.close(socketChannel);
        this.myAppDataMap.remove(socketChannel);
        this.myNetDataMap.remove(socketChannel);
        this.peerAppDataMap.remove(socketChannel);
        this.peerNetDataMap.remove(socketChannel);
    }

    @Override
    public ByteBuffer getMyAppData(SocketChannel socketChannel) {
        return this.myAppDataMap.get(socketChannel);
    }

    @Override
    public void setMyAppData(SocketChannel socketChannel, ByteBuffer myAppData) {
        this.myAppDataMap.put(socketChannel, myAppData);
    }

    @Override
    public ByteBuffer getMyNetData(SocketChannel socketChannel) {
        return this.myNetDataMap.get(socketChannel);
    }

    @Override
    public void setMyNetData(SocketChannel socketChannel, ByteBuffer myNetData) {
        this.myNetDataMap.put(socketChannel, myNetData);
    }

    @Override
    public ByteBuffer getPeerAppData(SocketChannel socketChannel) {
        return this.peerAppDataMap.get(socketChannel);
    }

    @Override
    public void setPeerAppData(SocketChannel socketChannel, ByteBuffer peerAppData) {
        this.peerAppDataMap.put(socketChannel, peerAppData);
    }

    @Override
    public ByteBuffer getPeerNetData(SocketChannel socketChannel) {
        return this.peerNetDataMap.get(socketChannel);
    }

    @Override
    public void setPeerNetData(SocketChannel socketChannel, ByteBuffer peerNetData) {
        this.peerNetDataMap.put(socketChannel, peerNetData);
    }

    @Override
    protected synchronized SSLEngine getSslEngine(SocketChannel socketChannel) {
        SSLEngine engine = this.engineBySocket.get(socketChannel);
        if (engine == null) {
            SSLSession dummySession = this.context.createSSLEngine().getSession();
            this.setMyAppData(socketChannel, ByteBuffer.allocate(dummySession.getApplicationBufferSize()));
            this.setMyNetData(socketChannel, ByteBuffer.allocate(dummySession.getPacketBufferSize()));
            this.setPeerAppData(socketChannel, ByteBuffer.allocate(dummySession.getApplicationBufferSize()));
            this.setPeerNetData(socketChannel, ByteBuffer.allocate(dummySession.getPacketBufferSize()));
            dummySession.invalidate();
            engine = this.context.createSSLEngine();
            engine.setUseClientMode(false);
            this.engineBySocket.put(socketChannel, engine);
        }
        return engine;
    }

    @Override
    public int read(SocketChannel socketChannel, ByteBuffer buffer) throws IOException {
        this.getPeerNetData(socketChannel).clear();
        int bytesRead = socketChannel.read(this.getPeerNetData(socketChannel));
        if (bytesRead > 0) {
            this.getPeerNetData(socketChannel).flip();
            block6: while (this.getPeerNetData(socketChannel).hasRemaining()) {
                this.getPeerAppData(socketChannel).clear();
                SSLEngineResult result = this.getSslEngine(socketChannel).unwrap(this.getPeerNetData(socketChannel), this.getPeerAppData(socketChannel));
                switch (result.getStatus()) {
                    case OK: {
                        this.getPeerAppData(socketChannel).flip();
                        bytesRead = this.getPeerAppData(socketChannel).limit();
                        buffer.put(this.getPeerAppData(socketChannel));
                        continue block6;
                    }
                    case BUFFER_OVERFLOW: {
                        this.setPeerAppData(socketChannel, this.enlargeApplicationBuffer(this.getSslEngine(socketChannel), this.getPeerAppData(socketChannel)));
                        continue block6;
                    }
                    case BUFFER_UNDERFLOW: {
                        this.setPeerNetData(socketChannel, this.handleBufferUnderflow(this.getSslEngine(socketChannel), this.getPeerNetData(socketChannel)));
                        continue block6;
                    }
                    case CLOSED: {
                        bytesRead = -1;
                        continue block6;
                    }
                }
                throw new IllegalStateException("Invalid SSL status: " + String.valueOf((Object)result.getStatus()));
            }
        }
        return bytesRead;
    }

    @Override
    public void write(SocketChannel socketChannel, ByteBuffer message) throws IOException {
        this.getMyAppData(socketChannel).clear();
        this.getMyAppData(socketChannel).put(message);
        this.getMyAppData(socketChannel).flip();
        block5: while (this.getMyAppData(socketChannel).hasRemaining()) {
            this.getMyNetData(socketChannel).clear();
            SSLEngineResult result = this.getSslEngine(socketChannel).wrap(this.getMyAppData(socketChannel), this.getMyNetData(socketChannel));
            switch (result.getStatus()) {
                case OK: {
                    this.getMyNetData(socketChannel).flip();
                    while (this.getMyNetData(socketChannel).hasRemaining()) {
                        socketChannel.write(this.getMyNetData(socketChannel));
                    }
                    Log.i("SSL", "Message sent to the client: " + String.valueOf(message), new Object[0]);
                    continue block5;
                }
                case BUFFER_OVERFLOW: {
                    this.setMyNetData(socketChannel, this.enlargePacketBuffer(this.getSslEngine(socketChannel), this.getMyNetData(socketChannel)));
                    continue block5;
                }
                case BUFFER_UNDERFLOW: {
                    throw new SSLException("Buffer underflow occurred after a wrap. I don't think we should ever get here.");
                }
            }
            throw new IllegalStateException("Invalid SSL status: " + String.valueOf((Object)result.getStatus()));
        }
    }
}

