/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers;

import java.lang.reflect.Method;
import java.util.Set;
import org.hcjf.errors.HCJFSecurityException;
import org.hcjf.layers.AdaptableLayer;
import org.hcjf.layers.LayerInterface;
import org.hcjf.layers.LayerProxy;
import org.hcjf.layers.Layers;
import org.hcjf.layers.plugins.PluginLayer;
import org.hcjf.log.debug.Agent;
import org.hcjf.log.debug.Agents;
import org.hcjf.service.Service;
import org.hcjf.service.ServiceSession;
import org.hcjf.service.ServiceThread;
import org.hcjf.service.security.Permission;
import org.hcjf.service.security.SecurityPermissions;
import org.hcjf.utils.SynchronizedCountOperation;

public abstract class Layer
implements LayerInterface {
    private final String implName;
    private final boolean stateful;
    private final SynchronizedCountOperation invocationMean;
    private final SynchronizedCountOperation executionTimeMean;
    private final SynchronizedCountOperation errorMean;

    public Layer(String implName, boolean stateful) {
        this.implName = implName;
        this.stateful = stateful;
        this.invocationMean = new SynchronizedCountOperation(SynchronizedCountOperation.getMeanOperation(), 1000L);
        this.executionTimeMean = new SynchronizedCountOperation(SynchronizedCountOperation.getMeanOperation(), 1000L);
        this.errorMean = new SynchronizedCountOperation(SynchronizedCountOperation.getMeanOperation(), 1000L);
        Agents.register(new LayerAgent(this));
    }

    public Layer(String implName) {
        this(implName, true);
    }

    public Layer(boolean stateful) {
        this(null, stateful);
    }

    public Layer() {
        this(null, true);
    }

    @Override
    public String getImplName() {
        return this.implName;
    }

    @Override
    public final boolean isStateful() {
        return this.stateful;
    }

    @Override
    public final boolean isPlugin() {
        return PluginLayer.class.isAssignableFrom(this.getClass());
    }

    public Set<String> getAliases() {
        return null;
    }

    public boolean isOverwritable() {
        return true;
    }

    protected Access checkAccess() {
        return Access.GRANTED;
    }

    protected final <L extends LayerInterface> L getLayer(Class<? extends L> layerClass, String implName) {
        return Layers.get(layerClass, implName);
    }

    public LayerProxy getProxy() {
        return new LayerProxy(){

            @Override
            public LayerProxy.ProxyInterceptor onBeforeInvoke(Method method, Object ... params) {
                return null;
            }

            @Override
            public void onAfterInvoke(Method method, Object result, Object ... params) {
            }
        };
    }

    private void analyzeThread() throws Throwable {
        ServiceThread.checkInterruptedThread();
        ServiceThread.checkAllocatedMemory();
        ServiceThread.checkExecutionTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        if (!(Thread.currentThread() instanceof ServiceThread)) {
            result = Service.call(() -> {
                try {
                    return this.invoke(proxy, method, args);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }, ServiceSession.getGuestSession());
        } else {
            this.invocationMean.add(1.0);
            Long startTime = System.currentTimeMillis();
            try {
                this.analyzeThread();
                Access access = this.checkAccess();
                if (access == null) {
                    throw new HCJFSecurityException("Access null", new Object[0]);
                }
                if (!access.granted) {
                    if (access.message != null && access.getThrowable() != null) {
                        throw new HCJFSecurityException(access.getMessage(), access.getThrowable(), new Object[0]);
                    }
                    if (access.getMessage() != null) {
                        throw new HCJFSecurityException(access.getMessage(), new Object[0]);
                    }
                    if (access.getThrowable() != null) {
                        throw new HCJFSecurityException("Empty message", access.getThrowable(), new Object[0]);
                    }
                }
                ServiceThread serviceThread = (ServiceThread)Thread.currentThread();
                serviceThread.putLayer(new ServiceSession.LayerStackElement(this.getClass(), this.getImplName(), this.isPlugin(), this.isStateful()));
                if (!method.getDeclaringClass().equals(LayerInterface.class)) {
                    Method implementationMethod = this.getTarget().getClass().getMethod(method.getName(), method.getParameterTypes());
                    for (Permission permission : (Permission[])implementationMethod.getDeclaredAnnotationsByType(Permission.class)) {
                        SecurityPermissions.checkPermission(this.getTarget().getClass(), permission.value());
                    }
                }
                try {
                    Object[] newArgs = AdaptableLayer.class.isAssignableFrom(this.getClass()) ? ((AdaptableLayer)((Object)this)).adaptArguments(method, args) : args;
                    LayerProxy.ProxyInterceptor interceptor = this.getProxy().onBeforeInvoke(method, newArgs);
                    result = interceptor == null || !interceptor.isCached() ? method.invoke(this.getTarget(), newArgs) : interceptor.getResult();
                    this.getProxy().onAfterInvoke(method, result, newArgs);
                }
                catch (Throwable throwable) {
                    this.errorMean.add(1.0);
                    throw throwable;
                }
                finally {
                    if (serviceThread != null) {
                        serviceThread.removeLayer();
                    }
                }
            }
            finally {
                this.executionTimeMean.add(System.currentTimeMillis() - startTime);
            }
        }
        return result;
    }

    protected Object getTarget() {
        return this;
    }

    protected final ServiceSession getSession() {
        return ((ServiceThread)Thread.currentThread()).getSession();
    }

    public static final class LayerAgent
    extends Agent
    implements LayerAgentMBean {
        private static final String PACKAGE_NAME = Layer.class.getPackageName();
        private static final String NAME_TEMPLATE = "%s$%s";
        private final Layer layer;

        public LayerAgent(Layer layer) {
            super(String.format(NAME_TEMPLATE, layer.getClass().getSimpleName(), layer.getImplName()), PACKAGE_NAME);
            this.layer = layer;
        }

        @Override
        public String getLayerName() {
            return this.layer.getImplName();
        }

        @Override
        public Double getInvocationMean() {
            return this.layer.invocationMean.getCurrentValue();
        }

        @Override
        public Double getErrorMean() {
            return this.layer.errorMean.getCurrentValue();
        }

        @Override
        public Double getExecutionTimeMean() {
            return this.layer.executionTimeMean.getCurrentValue();
        }
    }

    public static final class Access {
        private static final Access GRANTED = new Access(true);
        private final boolean granted;
        private final String message;
        private final Throwable throwable;

        public Access(boolean granted, String message, Throwable throwable) {
            this.granted = granted;
            this.message = message;
            this.throwable = throwable;
        }

        public Access(boolean granted, String message) {
            this(granted, message, null);
        }

        public Access(boolean granted) {
            this(granted, null, null);
        }

        public boolean isGranted() {
            return this.granted;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }

    public static interface LayerAgentMBean {
        public String getLayerName();

        public Double getInvocationMean();

        public Double getErrorMean();

        public Double getExecutionTimeMean();
    }
}

