/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.hcjf.layers.Layers;
import org.hcjf.layers.cache.CacheLayerInterface;
import org.hcjf.layers.cache.CacheServiceConsumer;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.Service;

public class CacheService
extends Service<CacheServiceConsumer> {
    private static final Integer TIME_WINDOWS_SIZE = 1000;
    private static CacheService instance;
    private Map<Long, List<CacheLayerInterface<?>>> cacheLayers;

    private CacheService() {
        super(SystemProperties.get("hcjf.cache.service.name"), SystemProperties.getInteger("hcjf.cache.service.priority"));
    }

    @Override
    protected void init() {
        super.init();
        this.cacheLayers = new HashMap();
        this.fork(() -> {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Long timeWindows = System.currentTimeMillis() / (long)TIME_WINDOWS_SIZE.intValue() * (long)TIME_WINDOWS_SIZE.intValue();
                    TreeSet<Long> tws = new TreeSet<Long>();
                    tws.addAll(this.cacheLayers.keySet());
                    for (Long tw : tws) {
                        if (timeWindows < tw) continue;
                        List<CacheLayerInterface<?>> list = this.cacheLayers.remove(tw);
                        for (CacheLayerInterface<?> layer : list) {
                            this.invalidate(layer);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static synchronized CacheService getInstance() {
        if (instance == null) {
            instance = new CacheService();
        }
        return instance;
    }

    private Long calculateTimeWindows(Long timestamp) {
        return timestamp / (long)TIME_WINDOWS_SIZE.intValue() * (long)TIME_WINDOWS_SIZE.intValue();
    }

    private synchronized void scheduleCache(CacheLayerInterface<?> cacheLayerInterface) {
        Long timeWindows = this.calculateTimeWindows(System.currentTimeMillis() + cacheLayerInterface.timout());
        List<CacheLayerInterface<?>> list = this.cacheLayers.get(timeWindows);
        if (list == null) {
            list = new ArrayList();
            this.cacheLayers.put(timeWindows, list);
        }
        list.add(cacheLayerInterface);
    }

    private void invalidate(CacheLayerInterface<?> cacheLayerInterface) {
        cacheLayerInterface.invalidate();
        this.scheduleCache(cacheLayerInterface);
    }

    @Override
    public void registerConsumer(CacheServiceConsumer consumer) {
        CacheLayerInterface cacheLayer = Layers.get(CacheLayerInterface.class, consumer.getCacheImpl());
        this.invalidate(cacheLayer);
    }

    @Override
    public void unregisterConsumer(CacheServiceConsumer consumer) {
    }
}

