/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.crud;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import org.hcjf.layers.AdaptableLayer;
import org.hcjf.layers.Layer;
import org.hcjf.layers.crud.CreateLayerInterface;
import org.hcjf.layers.crud.UpdateLayerInterface;
import org.hcjf.utils.Introspection;

public abstract class CrudLayer<O>
extends Layer
implements AdaptableLayer {
    private Class<O> resourceType;

    public CrudLayer(String implName) {
        super(implName);
    }

    public CrudLayer() {
    }

    public final synchronized Class<O> getResourceType() {
        if (this.resourceType == null) {
            Class<?> currentClass;
            Type genericSuperClass = currentClass.getGenericSuperclass();
            for (currentClass = this.getClass(); currentClass != Object.class && !(genericSuperClass instanceof ParameterizedType); currentClass = currentClass.getSuperclass()) {
                genericSuperClass = currentClass.getGenericSuperclass();
            }
            if (genericSuperClass instanceof ParameterizedType) {
                Type actualType = ((ParameterizedType)genericSuperClass).getActualTypeArguments()[0];
                this.resourceType = actualType instanceof ParameterizedType ? (Class)((ParameterizedType)actualType).getRawType() : (Class)actualType;
            } else {
                throw new IllegalArgumentException();
            }
        }
        return this.resourceType;
    }

    @Override
    public Object[] adaptArguments(Method method, Object[] args) {
        Object[] result = args;
        if (!Map.class.isAssignableFrom(this.getResourceType())) {
            if (method.getDeclaringClass().equals(CreateLayerInterface.class)) {
                result[0] = this.adaptObject((Map)result[0]);
            } else if (method.getDeclaringClass().equals(UpdateLayerInterface.class)) {
                if (args.length == 1) {
                    result[0] = this.adaptObject((Map)result[0]);
                } else {
                    result[1] = this.adaptObject((Map)result[1]);
                }
            }
        }
        return result;
    }

    private O adaptObject(Map<String, Object> parameter) {
        O result = null;
        if (parameter != null) {
            try {
                result = Introspection.toInstance(parameter, this.getResourceType());
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to adapt the call arguments", ex);
            }
        }
        return result;
    }
}

