/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.crud.command;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.hcjf.layers.LayerInterface;
import org.hcjf.layers.Layers;
import org.hcjf.layers.crud.command.CommandRequestModel;
import org.hcjf.layers.crud.command.ResourceCommandLayerInterface;
import org.hcjf.utils.Introspection;

public interface CommandUpdateLayerInterface
extends LayerInterface {
    public static final String INSTANCE_ID = "__instanceId__";

    default public Map<String, Object> executeUpdateCommand(CommandRequestModel command) {
        String resourceName = this.getImplName();
        ResourceCommandLayerInterface resourceCommand = Layers.get(ResourceCommandLayerInterface.class, String.format("%s::%s", resourceName, command.getCommand()));
        Map<String, Object> payload = command.getPayload();
        payload.put(INSTANCE_ID, command.getInstanceId());
        return resourceCommand.execute(command.getPayload());
    }

    default public <O> O getInstanceId(Map<String, Object> payload) {
        return Introspection.resolve(payload, INSTANCE_ID);
    }

    default public Collection<Map<String, Object>> executeUpdateCommands(Collection<CommandRequestModel> commands) {
        return commands.stream().map(this::executeUpdateCommand).collect(Collectors.toList());
    }
}

