/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.layers.query.Queryable;
import org.hcjf.utils.JsonUtils;

public class JsonQuery {
    public static Collection<Map<String, Object>> evaluate(Queryable queryable, String json) {
        Object jsonObject = JsonUtils.createObject(json);
        ArrayList<Map> source = new ArrayList<Map>();
        if (jsonObject instanceof Collection) {
            source.addAll((Collection)jsonObject);
        } else if (jsonObject instanceof Map) {
            source.add((Map)jsonObject);
        } else {
            throw new HCJFRuntimeException("Illegal data type in order to create data source", new Object[0]);
        }
        return queryable.evaluate(source);
    }

    public static Collection<Map<String, Object>> evaluate(Queryable queryable, Path path) {
        try {
            return JsonQuery.evaluate(queryable, new String(Files.readAllBytes(path)));
        }
        catch (IOException ex) {
            throw new HCJFRuntimeException("Fail to read path in order to crear the source", (Throwable)ex, new Object[0]);
        }
    }

    public static Collection<Map<String, Object>> evaluate(Queryable queryable, ByteBuffer jsonFile) {
        byte[] array = new byte[jsonFile.limit() - jsonFile.position()];
        jsonFile.get(array);
        return JsonQuery.evaluate(queryable, new String(array));
    }
}

