/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hcjf.bson.BsonDocument;
import org.hcjf.layers.Layer;
import org.hcjf.layers.Layers;
import org.hcjf.layers.query.Query;
import org.hcjf.layers.query.Queryable;
import org.hcjf.layers.query.model.QueryFunction;
import org.hcjf.layers.query.model.QueryParameter;
import org.hcjf.utils.bson.BsonCustomBuilderLayer;
import org.hcjf.utils.bson.BsonParcelable;

public class ParameterizedQuery
implements Queryable {
    private static final String QUERY_BSON_FIELD_NAME = "__query__";
    private static final String PARAMS_BSON_FIELD_NAME = "__params__";
    private final Query query;
    private final List<Object> parameters;

    public ParameterizedQuery(Query query) {
        this.query = query;
        this.parameters = new ArrayList<Object>();
    }

    @Override
    public String getResourceName() {
        return this.query.getResourceName();
    }

    public final ParameterizedQuery add(Object parameter) {
        this.parameters.add(parameter);
        return this;
    }

    public final ParameterizedQuery set(Integer place, Object parameter) {
        if (place.intValue() == this.parameters.size()) {
            this.add(parameter);
        } else {
            if (this.parameters.size() <= place) {
                for (int i = this.parameters.size(); i <= place; ++i) {
                    this.parameters.add(null);
                }
            }
            this.parameters.set(place, parameter);
        }
        return this;
    }

    public List<Object> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public final <O> Collection<O> evaluate(Collection<O> dataSource) {
        return this.evaluate((Queryable query) -> dataSource, new Queryable.IntrospectionConsumer());
    }

    @Override
    public final <O> Collection<O> evaluate(Collection<O> dataSource, Queryable.Consumer<O> consumer) {
        return this.evaluate((Queryable query) -> dataSource, consumer);
    }

    @Override
    public final <O> Collection<O> evaluate(Queryable.DataSource<O> dataSource) {
        return this.evaluate(dataSource, new Queryable.IntrospectionConsumer());
    }

    @Override
    public final <O> Collection<O> evaluate(Queryable.DataSource<O> dataSource, Queryable.Consumer<O> consumer) {
        Collection<O> result = this.query.evaluate(dataSource, new ParameterizedConsumer(consumer));
        this.parameters.clear();
        return result;
    }

    @Override
    public BsonDocument toBson() {
        BsonDocument document = new BsonDocument();
        document.put("__pcn__", (Object)this.getClass().getName());
        document.put(QUERY_BSON_FIELD_NAME, (Object)this.query.toString());
        document.put(PARAMS_BSON_FIELD_NAME, this.parameters);
        return document;
    }

    @Override
    public <P extends BsonParcelable> P populate(BsonDocument document) {
        Collection collection = this.fromBson(Object.class, document.get(PARAMS_BSON_FIELD_NAME).getAsArray());
        this.parameters.addAll(collection);
        return (P)this;
    }

    public String toString() {
        return this.getQuery().toString();
    }

    static {
        Layers.publishLayer(ParameterizedQueryBsonCustomBuilderLayer.class);
    }

    public class ParameterizedConsumer
    extends Queryable.DefaultConsumer {
        private final Queryable.Consumer consumer;

        public ParameterizedConsumer(Queryable.Consumer consumer) {
            this.consumer = consumer;
        }

        @Override
        public Object get(Object instance, QueryParameter queryParameter, Queryable.DataSource dataSource) {
            Object result = queryParameter instanceof QueryFunction ? this.resolveFunction((QueryFunction)queryParameter, instance, dataSource) : this.consumer.get(instance, queryParameter, dataSource);
            return result;
        }

        @Override
        public Object getParameter(Integer place) {
            return ParameterizedQuery.this.parameters.get(place);
        }

        public List<Object> getParameters() {
            return Collections.unmodifiableList(ParameterizedQuery.this.parameters);
        }
    }

    public static class ParameterizedQueryBsonCustomBuilderLayer
    extends Layer
    implements BsonCustomBuilderLayer<ParameterizedQuery> {
        public ParameterizedQueryBsonCustomBuilderLayer() {
            super(ParameterizedQuery.class.getName());
        }

        @Override
        public ParameterizedQuery create(BsonDocument document) {
            return new ParameterizedQuery(Query.compile(document.get(ParameterizedQuery.QUERY_BSON_FIELD_NAME).getAsString()));
        }
    }
}

