/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.layers.Layers;
import org.hcjf.layers.crud.ReadRowsLayerInterface;
import org.hcjf.layers.query.JoinableMap;
import org.hcjf.layers.query.Query;
import org.hcjf.layers.query.evaluators.BaseEvaluator;
import org.hcjf.layers.query.functions.QueryAggregateFunctionLayerInterface;
import org.hcjf.layers.query.functions.QueryFunctionLayerInterface;
import org.hcjf.layers.query.model.QueryConditional;
import org.hcjf.layers.query.model.QueryField;
import org.hcjf.layers.query.model.QueryFunction;
import org.hcjf.layers.query.model.QueryParameter;
import org.hcjf.layers.query.model.QueryReturnConditional;
import org.hcjf.layers.query.model.QueryReturnField;
import org.hcjf.layers.query.model.QueryReturnFunction;
import org.hcjf.layers.query.model.QueryReturnLiteral;
import org.hcjf.layers.query.model.QueryReturnParameter;
import org.hcjf.layers.query.model.QueryReturnUnprocessedValue;
import org.hcjf.properties.SystemProperties;
import org.hcjf.utils.Introspection;
import org.hcjf.utils.bson.BsonParcelable;

public interface Queryable
extends BsonParcelable {
    public String getResourceName();

    public Query getQuery();

    public <O> Collection<O> evaluate(Collection<O> var1);

    public <O> Collection<O> evaluate(Collection<O> var1, Consumer<O> var2);

    public <O> Collection<O> evaluate(DataSource<O> var1);

    public <O> Collection<O> evaluate(DataSource<O> var1, Consumer<O> var2);

    public static class ReadableDataSource
    implements DataSource<JoinableMap> {
        @Override
        public Collection<JoinableMap> getResourceData(Queryable queryable) {
            return Layers.get(ReadRowsLayerInterface.class, queryable.getResourceName()).readRows(queryable);
        }
    }

    public static class IntrospectionConsumer<O>
    extends DefaultConsumer<O> {
        @Override
        public <R> R get(O instance, QueryParameter queryParameter, DataSource<O> dataSource) {
            Object result = null;
            if (queryParameter instanceof QueryField) {
                QueryField queryField = (QueryField)queryParameter;
                result = queryField.getFieldPath().equals(SystemProperties.get("hcjf.query.return.all.reserved.word")) ? SystemProperties.get("hcjf.query.return.all.reserved.word") : queryField.resolve(instance);
            } else if (queryParameter instanceof QueryConditional) {
                QueryConditional conditional = (QueryConditional)((Object)queryParameter);
                result = conditional.getEvaluationQuery().verifyCondition(instance, dataSource, this);
            } else if (queryParameter instanceof QueryFunction) {
                result = this.resolveFunction((QueryFunction)queryParameter, instance, dataSource);
            }
            return (R)result;
        }

        @Override
        public <R> R getParameter(Integer place) {
            throw new UnsupportedOperationException();
        }
    }

    public static abstract class DefaultConsumer<O>
    implements Consumer<O> {
        @Override
        public <R> R resolveFunction(QueryFunction function, Object instance, DataSource<O> dataSource) {
            Object result;
            ArrayList<Object> parameterValues = new ArrayList<Object>();
            for (int i = 0; i < function.getParameters().size(); ++i) {
                Exception value;
                Object currentParameter = function.getParameters().get(i);
                if (currentParameter == null) continue;
                if (currentParameter instanceof QueryFunction) {
                    if (function instanceof QueryReturnFunction && ((QueryReturnFunction)function).isAggregate()) {
                        parameterValues.add(currentParameter);
                        continue;
                    }
                    QueryFunction innerFunction = (QueryFunction)currentParameter;
                    try {
                        value = this.resolveFunction(innerFunction, instance, dataSource);
                    }
                    catch (Exception ex) {
                        value = ex;
                    }
                    parameterValues.add(value);
                    continue;
                }
                if (currentParameter instanceof QueryParameter) {
                    if (function instanceof QueryReturnFunction && ((QueryReturnFunction)function).isAggregate()) {
                        parameterValues.add(currentParameter);
                        continue;
                    }
                    value = this.get(instance, (QueryParameter)currentParameter, dataSource);
                    if (value != null && value.equals("*")) {
                        HashMap<String, Object> copy = new HashMap<String, Object>();
                        copy.putAll(Introspection.toMap(instance));
                        parameterValues.add(copy);
                        continue;
                    }
                    parameterValues.add(value);
                    continue;
                }
                if (currentParameter instanceof BaseEvaluator.UnprocessedValue) {
                    DataSource<O> currentDataSource = dataSource;
                    if (currentParameter instanceof BaseEvaluator.QueryValue && function instanceof QueryReturnFunction && ((QueryReturnFunction)function).isAggregate()) {
                        currentDataSource = queryable -> (Collection)Introspection.deepCopy(instance);
                    }
                    parameterValues.add(((BaseEvaluator.UnprocessedValue)currentParameter).process(currentDataSource, this));
                    continue;
                }
                parameterValues.add(currentParameter);
            }
            if (function instanceof QueryReturnFunction && ((QueryReturnFunction)function).isAggregate()) {
                QueryAggregateFunctionLayerInterface queryAggregateFunctionLayerInterface = Layers.get(QueryAggregateFunctionLayerInterface.class, SystemProperties.get("hcjf.query.function.name.prefix") + function.getFunctionName());
                String alias = ((QueryReturnFunction)function).getAlias() == null ? function.toString() : ((QueryReturnFunction)function).getAlias();
                result = queryAggregateFunctionLayerInterface.evaluate(alias, (Collection)instance, parameterValues.toArray());
            } else {
                QueryFunctionLayerInterface queryFunctionLayerInterface = Layers.get(QueryFunctionLayerInterface.class, SystemProperties.get("hcjf.query.function.name.prefix") + function.getFunctionName());
                result = queryFunctionLayerInterface.evaluate(function.getFunctionName(), parameterValues.toArray());
            }
            return (R)result;
        }
    }

    public static interface DataSource<O> {
        public Collection<O> getResourceData(Queryable var1);
    }

    public static interface Consumer<O> {
        public <R> R get(O var1, QueryParameter var2, DataSource<O> var3);

        public <R> R resolveFunction(QueryFunction var1, Object var2, DataSource<O> var3);

        public <R> R getParameter(Integer var1);

        default public Map.Entry<String, Object> resolveQueryReturnParameter(QueryReturnParameter returnParameter, Object instance, DataSource<O> dataSource) {
            AbstractMap.SimpleEntry<String, Object> result = null;
            String name = null;
            Object value = null;
            if (returnParameter instanceof QueryReturnField) {
                QueryReturnField returnField = (QueryReturnField)returnParameter;
                name = returnField.getAlias();
                value = this.get(instance, returnField, dataSource);
            } else if (returnParameter instanceof QueryReturnLiteral) {
                QueryReturnLiteral queryReturnLiteral = (QueryReturnLiteral)returnParameter;
                name = queryReturnLiteral.getAlias();
                value = queryReturnLiteral.getValue();
            } else if (returnParameter instanceof QueryReturnConditional) {
                QueryReturnConditional returnConditional = (QueryReturnConditional)returnParameter;
                name = returnConditional.getAlias();
                value = this.get(instance, returnConditional, dataSource);
            } else if (returnParameter instanceof QueryReturnFunction && !((QueryReturnFunction)returnParameter).isAggregate()) {
                QueryReturnFunction function = (QueryReturnFunction)returnParameter;
                name = function.getAlias();
                value = this.resolveFunction(function, instance, dataSource);
            } else if (returnParameter instanceof QueryReturnUnprocessedValue) {
                QueryReturnUnprocessedValue queryReturnUnprocessedValue = (QueryReturnUnprocessedValue)returnParameter;
                BaseEvaluator.UnprocessedValue unprocessedValue = queryReturnUnprocessedValue.getUnprocessedValue();
                DataSource<O> unprocessedDataSource = dataSource;
                if (unprocessedValue instanceof BaseEvaluator.QueryValue) {
                    BaseEvaluator.QueryValue queryValue = (BaseEvaluator.QueryValue)unprocessedValue;
                    String resourceName = queryValue.getQuery().getResource().getResourceName();
                    Map<String, Object> originalEnvironment = queryValue.getQuery().getEnvironment();
                    HashMap<Object, Object> newEnvironment = originalEnvironment != null ? new HashMap<String, Object>(originalEnvironment) : new HashMap();
                    newEnvironment.putAll(Introspection.toMap(instance));
                    queryValue.getQuery().setEnvironment(newEnvironment);
                    Object dataset = Introspection.resolve(instance, resourceName);
                    if (dataset != null) {
                        if (dataset instanceof Collection) {
                            unprocessedDataSource = queryable -> (Collection)Introspection.deepCopy(dataset);
                        } else if (dataset instanceof Map) {
                            ArrayList collection = new ArrayList();
                            collection.add(Introspection.deepCopy(dataset));
                            unprocessedDataSource = queryable -> collection;
                        } else {
                            throw new HCJFRuntimeException("The resource path of query into a return values must point ot the collection value", new Object[0]);
                        }
                    }
                    value = unprocessedValue.process(unprocessedDataSource, this);
                    queryValue.getQuery().setEnvironment(originalEnvironment);
                } else {
                    value = unprocessedValue.process(unprocessedDataSource, this);
                }
                name = queryReturnUnprocessedValue.getAlias();
            }
            if (name != null) {
                result = new AbstractMap.SimpleEntry<String, Object>(name, value);
            }
            return result;
        }
    }
}

