/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.evaluators;

import java.math.BigDecimal;
import java.util.Map;
import org.hcjf.layers.query.Queryable;
import org.hcjf.layers.query.evaluators.BaseEvaluator;
import org.hcjf.layers.query.evaluators.Evaluator;
import org.hcjf.layers.query.model.QueryField;
import org.hcjf.layers.query.model.QueryParameter;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.ServiceSession;

public abstract class FieldEvaluator
extends BaseEvaluator {
    private final Object leftValue;
    private final Object rightValue;

    public FieldEvaluator(Object leftValue, Object rightValue) {
        this.leftValue = leftValue;
        this.rightValue = rightValue;
    }

    public final boolean containsReference(String fieldName) {
        boolean result = false;
        if (this.getLeftValue() instanceof QueryField) {
            result = ((QueryField)this.getLeftValue()).getFieldPath().equals(fieldName);
        }
        if (!result && this.getRightValue() instanceof QueryField) {
            result = ((QueryField)this.getRightValue()).getFieldPath().equals(fieldName);
        }
        return result;
    }

    public final Object getLeftValue() {
        return this.leftValue;
    }

    protected final Object getProcessedLeftValue(Object currentResultSetElement, Queryable.DataSource dataSource, Queryable.Consumer consumer) {
        Object result;
        if (this.getLeftValue() instanceof QueryParameter) {
            result = this.getProcessedValue(currentResultSetElement, this.getLeftValue(), dataSource, consumer);
        } else {
            Map<Evaluator, Object> cache = this.getLeftCache();
            if (cache != null) {
                result = cache.get(this);
                if (result == null) {
                    result = this.getProcessedValue(currentResultSetElement, this.getLeftValue(), dataSource, consumer);
                    cache.put(this, result);
                }
            } else {
                result = this.getProcessedValue(currentResultSetElement, this.getLeftValue(), dataSource, consumer);
            }
        }
        return result;
    }

    private final Map<Evaluator, Object> getLeftCache() {
        return (Map)((ServiceSession)ServiceSession.getCurrentIdentity()).get(SystemProperties.get("hcjf.query.evaluator.left.values.cache"));
    }

    public final Object getRightValue() {
        return this.rightValue;
    }

    protected final Object getProcessedRightValue(Object currentResultSetElement, Queryable.DataSource dataSource, Queryable.Consumer consumer) {
        Object result;
        if (this.getRightValue() instanceof QueryParameter) {
            result = this.getProcessedValue(currentResultSetElement, this.getRightValue(), dataSource, consumer);
        } else {
            Map<Evaluator, Object> cache = this.getRightCache();
            if (cache != null) {
                result = cache.get(this);
                if (result == null) {
                    result = this.getProcessedValue(currentResultSetElement, this.getRightValue(), dataSource, consumer);
                    cache.put(this, result);
                }
            } else {
                result = this.getProcessedValue(currentResultSetElement, this.getRightValue(), dataSource, consumer);
            }
        }
        return result;
    }

    private Map<Evaluator, Object> getRightCache() {
        return (Map)((ServiceSession)ServiceSession.getCurrentIdentity()).get(SystemProperties.get("hcjf.query.evaluator.right.values.cache"));
    }

    public final FieldEvaluator copy() {
        try {
            return (FieldEvaluator)this.getClass().getConstructor(Object.class, Object.class).newInstance(this.leftValue, this.rightValue);
        }
        catch (Exception e) {
            throw new RuntimeException("", e);
        }
    }

    protected boolean numberEquals(Number fieldValue, Object value) {
        boolean result = false;
        if (value instanceof Number) {
            result = fieldValue instanceof Double || fieldValue instanceof Float || value instanceof Double || value instanceof Float ? new BigDecimal(fieldValue.doubleValue()).equals(new BigDecimal(((Number)value).doubleValue())) : fieldValue.longValue() == ((Number)value).longValue();
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj.getClass().equals(this.getClass())) {
            FieldEvaluator fieldEvaluator = (FieldEvaluator)obj;
            result = this.leftValue.equals(fieldEvaluator.leftValue) && this.rightValue.equals(fieldEvaluator.rightValue);
        }
        return result;
    }

    public String toString() {
        return String.valueOf(this.getClass()) + "[" + String.valueOf(this.leftValue) + "," + String.valueOf(this.rightValue) + "]";
    }
}

