/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.functions;

import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.ogc.OGCGeometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.layers.query.Enlarged;
import org.hcjf.layers.query.JoinableMap;
import org.hcjf.layers.query.functions.BaseQueryAggregateFunctionLayer;
import org.hcjf.utils.GeoUtils;

public class GeoDistanceAggregateFunctionLayer
extends BaseQueryAggregateFunctionLayer {
    private static final String NAME = "geoAggregateDistance";

    public GeoDistanceAggregateFunctionLayer() {
        super(NAME);
    }

    @Override
    public Collection evaluate(String alias, Collection resultSet, Object ... parameters) {
        ArrayList<JoinableMap> result = resultSet;
        if (parameters.length == 0) {
            throw new HCJFRuntimeException("The geoAggregateDistance function need at least one parameter", new Object[0]);
        }
        OGCGeometry previousGeometry = null;
        double totalDistance = 0.0;
        double distance = 0.0;
        boolean accumulate = parameters.length >= 2 && (Boolean)parameters[1] != false;
        boolean group = parameters.length >= 3 && (Boolean)parameters[2] != false;
        for (Object e : result) {
            OGCGeometry currentGeometry = GeoUtils.createGeometry(this.resolveValue(e, parameters[0]));
            if (previousGeometry != null) {
                distance = GeometryEngine.geodesicDistanceOnWGS84((Point)((Point)previousGeometry.centroid().getEsriGeometry()), (Point)((Point)currentGeometry.centroid().getEsriGeometry()));
                totalDistance += distance;
            }
            previousGeometry = currentGeometry;
            if (group) continue;
            if (accumulate) {
                ((Enlarged)e).put(alias, totalDistance);
                continue;
            }
            ((Enlarged)e).put(alias, distance);
        }
        if (group) {
            ArrayList<JoinableMap> newResultSet = new ArrayList<JoinableMap>();
            JoinableMap joinableMap = new JoinableMap(new HashMap<String, Object>(), alias);
            joinableMap.put(alias, (Object)totalDistance);
            newResultSet.add(joinableMap);
            result = newResultSet;
        }
        return result;
    }
}

