/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.functions;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.layers.query.functions.BaseQueryFunctionLayer;
import org.hcjf.layers.query.functions.NumberSetFunction;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.ServiceSession;
import org.hcjf.utils.MathIntrospection;
import org.hcjf.utils.Maths;
import org.hcjf.utils.Matrix;

public class MathQueryFunctionLayer
extends BaseQueryFunctionLayer
implements NumberSetFunction {
    private static final String ARITHMETIC = "arithmetic";
    private static final String GEOMETRIC = "geometric";
    private static final String HARMONIC = "harmonic";
    private static final String MEDIAN = "median";
    private static final String SUM = "sum";
    private static final String PRODUCT = "product";
    private static final String BYTE_VALUE = "byteValue";
    private static final String SHORT_VALUE = "shortValue";
    private static final String INTEGER_VALUE = "integerValue";
    private static final String LONG_VALUE = "longValue";
    private static final String FLOAT_VALUE = "floatValue";
    private static final String DOUBLE_VALUE = "doubleValue";
    private static final String MEAN = "mean";
    private static final String NUMBER_FORMAT = "numberFormat";
    private static final String CURRENCY_FORMAT = "currencyFormat";
    private static final String PERCENT_FORMAT = "percentFormat";
    private static final String PARSE_NUMBER = "parseNumber";
    private static final String NEW_MATRIX = "newMatrix";
    private static final String NEW_SUB_MATRIX = "newSubMatrix";
    private static final String NEW_IDENTITY_MATRIX = "newIdentityMatrix";
    private static final String IS_SQUARE_MATRIX = "isSquareMatrix";
    private static final String MATRIX_GET = "matrixGet";
    private static final String MATRIX_SET = "matrixSet";
    private static final String MATRIX_ADD = "matrixAdd";
    private static final String MATRIX_SUBTRACT = "matrixSubtract";
    private static final String MATRIX_MULTIPLY = "matrixMultiply";
    private static final String MATRIX_MULTIPLY_BY_SCALAR = "matrixMultiplyByScalar";
    private static final String MATRIX_TRANSPOSE = "matrixTranspose";
    private static final String MATRIX_DETERMINANT = "matrixDeterminant";
    private static final String MATRIX_COFACTOR = "matrixCofactor";
    private static final String MATRIX_INVERSE = "matrixInverse";
    private static final String EVAL_EXPRESSION = SystemProperties.get("hcjf.query.function.math.eval.expression.name");

    public MathQueryFunctionLayer() {
        super(SystemProperties.get("hcjf.query.function.math.name"));
        for (String functionName : MathIntrospection.getMethodsSet()) {
            this.addFunctionName(functionName);
        }
        this.addFunctionName(SUM);
        this.addFunctionName(PRODUCT);
        this.addFunctionName(BYTE_VALUE);
        this.addFunctionName(SHORT_VALUE);
        this.addFunctionName(INTEGER_VALUE);
        this.addFunctionName(LONG_VALUE);
        this.addFunctionName(FLOAT_VALUE);
        this.addFunctionName(DOUBLE_VALUE);
        this.addFunctionName(MEAN);
        this.addFunctionName(NUMBER_FORMAT);
        this.addFunctionName(CURRENCY_FORMAT);
        this.addFunctionName(PERCENT_FORMAT);
        this.addFunctionName(PARSE_NUMBER);
        this.addFunctionName(EVAL_EXPRESSION);
        this.addFunctionName(NEW_MATRIX);
        this.addFunctionName(NEW_SUB_MATRIX);
        this.addFunctionName(NEW_IDENTITY_MATRIX);
        this.addFunctionName(IS_SQUARE_MATRIX);
        this.addFunctionName(MATRIX_GET);
        this.addFunctionName(MATRIX_SET);
        this.addFunctionName(MATRIX_ADD);
        this.addFunctionName(MATRIX_SUBTRACT);
        this.addFunctionName(MATRIX_MULTIPLY);
        this.addFunctionName(MATRIX_MULTIPLY_BY_SCALAR);
        this.addFunctionName(MATRIX_TRANSPOSE);
        this.addFunctionName(MATRIX_DETERMINANT);
        this.addFunctionName(MATRIX_COFACTOR);
        this.addFunctionName(MATRIX_INVERSE);
    }

    @Override
    public Object evaluate(String functionName, Object ... parameters) {
        Object result;
        switch (functionName) {
            case "sum": {
                Number[] accumulator = this.accumulateFunction(0, parameters, BigDecimal::add);
                result = accumulator[1];
                break;
            }
            case "product": {
                Number[] accumulator = this.accumulateFunction(1, parameters, BigDecimal::add);
                result = accumulator[1];
                break;
            }
            case "mean": {
                String function;
                Integer accumulatedValue = 0;
                String string = function = parameters.length == 1 ? ARITHMETIC : (String)parameters[1];
                if (function.equals(GEOMETRIC)) {
                    Number[] functionResult = this.accumulateFunction(accumulatedValue, new Object[]{parameters[0]}, (A, V) -> A.multiply((BigDecimal)V));
                    result = Math.pow(functionResult[1].doubleValue(), 1.0 / functionResult[0].doubleValue());
                    break;
                }
                if (function.equals(HARMONIC)) {
                    Number[] functionResult = this.accumulateFunction(accumulatedValue, new Object[]{parameters[0]}, (A, V) -> A.add(V.pow(-1)));
                    result = functionResult[0].doubleValue() / functionResult[1].doubleValue();
                    break;
                }
                if (function.equals(MEDIAN)) {
                    if (parameters[0] instanceof Collection || parameters[0].getClass().isArray()) {
                        List<Object> collection;
                        List<Object> list = collection = parameters[0] instanceof Collection ? (List<Object>)parameters[0] : Arrays.asList(parameters[0]);
                        if (collection.isEmpty()) {
                            result = 0;
                            break;
                        }
                        if (collection.size() == 1) {
                            result = collection.stream().iterator().next();
                            break;
                        }
                        int size = collection.size();
                        result = collection.stream().sorted().skip(size / 2).findFirst().get();
                        break;
                    }
                    result = parameters[0];
                    break;
                }
                Number[] functionResult = this.accumulateFunction(accumulatedValue, new Object[]{parameters[0]}, (A, V) -> A.add((BigDecimal)V));
                result = functionResult[1].doubleValue() / functionResult[0].doubleValue();
                break;
            }
            case "byteValue": {
                result = ((Number)this.getParameter(0, parameters)).byteValue();
                break;
            }
            case "shortValue": {
                result = ((Number)this.getParameter(0, parameters)).shortValue();
                break;
            }
            case "integerValue": {
                result = ((Number)this.getParameter(0, parameters)).intValue();
                break;
            }
            case "longValue": {
                result = ((Number)this.getParameter(0, parameters)).longValue();
                break;
            }
            case "floatValue": {
                result = Float.valueOf(((Number)this.getParameter(0, parameters)).floatValue());
                break;
            }
            case "doubleValue": {
                result = ((Number)this.getParameter(0, parameters)).doubleValue();
                break;
            }
            case "numberFormat": {
                String pattern = (String)this.getParameter(0, parameters);
                Number number = (Number)this.getParameter(1, parameters);
                DecimalFormat numberFormat = new DecimalFormat(pattern);
                result = numberFormat.format(number);
                break;
            }
            case "currencyFormat": {
                Number number = (Number)this.getParameter(0, parameters);
                Locale locale = ((ServiceSession)ServiceSession.getCurrentIdentity()).getLocale();
                result = NumberFormat.getCurrencyInstance(locale).format(number.doubleValue());
                break;
            }
            case "percentFormat": {
                Number number = (Number)this.getParameter(0, parameters);
                Locale locale = ((ServiceSession)ServiceSession.getCurrentIdentity()).getLocale();
                result = NumberFormat.getPercentInstance(locale).format(number.doubleValue());
                break;
            }
            case "parseNumber": {
                String pattern = (String)this.getParameter(0, parameters);
                String source = (String)this.getParameter(1, parameters);
                DecimalFormat numberFormat = new DecimalFormat(pattern);
                try {
                    result = numberFormat.parse(source);
                    break;
                }
                catch (ParseException ex) {
                    throw new HCJFRuntimeException("Number parse fail", (Throwable)ex, new Object[0]);
                }
            }
            case "newMatrix": {
                Number rows = (Number)this.getParameter(0, parameters);
                Number cols = (Number)this.getParameter(1, parameters);
                if (parameters.length >= 3) {
                    List values = (List)this.getParameter(2, parameters);
                    result = new Matrix(rows.intValue(), cols.intValue(), values.toArray(new Number[0]));
                    break;
                }
                result = new Matrix(rows.intValue(), cols.intValue(), new Number[0]);
                break;
            }
            case "newIdentityMatrix": {
                Number size = (Number)this.getParameter(0, parameters);
                result = Matrix.identity(size.intValue());
                break;
            }
            case "newSubMatrix": {
                Matrix matrix = (Matrix)this.getParameter(0, parameters);
                Number excludeRow = (Number)this.getParameter(1, parameters);
                Number excludeColumn = (Number)this.getParameter(2, parameters);
                result = Maths.createSubMatrix(matrix, excludeRow.intValue(), excludeColumn.intValue());
                break;
            }
            case "isSquareMatrix": {
                Matrix matrix = (Matrix)this.getParameter(0, parameters);
                result = matrix.isSquare();
                break;
            }
            case "matrixGet": {
                Matrix matrix = (Matrix)this.getParameter(0, parameters);
                Number row = (Number)this.getParameter(1, parameters);
                Number col = (Number)this.getParameter(2, parameters);
                result = matrix.get(row.intValue(), col.intValue());
                break;
            }
            case "matrixSet": {
                Matrix matrix = (Matrix)this.getParameter(0, parameters);
                Number row = (Number)this.getParameter(1, parameters);
                Number col = (Number)this.getParameter(2, parameters);
                Number value = (Number)this.getParameter(3, parameters);
                matrix.set(row.intValue(), col.intValue(), value);
                result = matrix;
                break;
            }
            case "matrixAdd": {
                Matrix matrixA = (Matrix)this.getParameter(0, parameters);
                Matrix matrixB = (Matrix)this.getParameter(1, parameters);
                result = Maths.matrixAdd(matrixA, matrixB);
                break;
            }
            case "matrixSubtract": {
                Matrix matrixA = (Matrix)this.getParameter(0, parameters);
                Matrix matrixB = (Matrix)this.getParameter(1, parameters);
                result = Maths.matrixSubtract(matrixA, matrixB);
                break;
            }
            case "matrixMultiply": {
                Matrix matrixA = (Matrix)this.getParameter(0, parameters);
                Matrix matrixB = (Matrix)this.getParameter(1, parameters);
                result = Maths.matrixMultiply(matrixA, matrixB);
                break;
            }
            case "matrixMultiplyByScalar": {
                Matrix matrix = (Matrix)this.getParameter(0, parameters);
                Number scalar = (Number)this.getParameter(1, parameters);
                result = Maths.matrixMultiplyByScalar(matrix, scalar);
                break;
            }
            case "matrixTranspose": {
                Matrix matrix = (Matrix)this.getParameter(0, parameters);
                result = Maths.matrixTranspose(matrix);
                break;
            }
            case "matrixCofactor": {
                Matrix matrix = (Matrix)this.getParameter(0, parameters);
                result = Maths.matrixCofactor(matrix);
                break;
            }
            case "matrixDeterminant": {
                Matrix matrix = (Matrix)this.getParameter(0, parameters);
                result = Maths.matrixDeterminant(matrix);
                break;
            }
            case "matrixInverse": {
                Matrix matrix = (Matrix)this.getParameter(0, parameters);
                result = Maths.matrixInverse(matrix);
                break;
            }
            default: {
                result = functionName.equals(EVAL_EXPRESSION) ? this.evalExpression(parameters) : MathIntrospection.invoke(functionName, parameters);
            }
        }
        return result;
    }
}

