/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.functions;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.layers.query.JoinableMap;
import org.hcjf.layers.query.functions.BaseQueryAggregateFunctionLayer;
import org.hcjf.layers.query.functions.NumberSetFunction;
import org.hcjf.properties.SystemProperties;

public class MeanAggregateFunctionLayer
extends BaseQueryAggregateFunctionLayer
implements NumberSetFunction {
    public static final String NAME = "aggregateMean";
    public static final String ARITHMETIC = "arithmetic";
    public static final String GEOMETRIC = "geometric";
    public static final String HARMONIC = "harmonic";
    public static final String MEDIAN = "median";

    public MeanAggregateFunctionLayer() {
        super(NAME);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection evaluate(String alias, Collection resultSet, Object ... parameters) {
        ArrayList<JoinableMap> result = resultSet;
        if (parameters.length >= 1) {
            try {
                Number meanValue;
                String meanKind = ARITHMETIC;
                if (parameters.length >= 2) {
                    meanKind = (String)this.getParameter(1, parameters);
                }
                boolean group = true;
                if (parameters.length >= 3) {
                    group = (Boolean)this.getParameter(2, parameters);
                }
                if (meanKind.equals(MEDIAN)) {
                    meanValue = 0;
                    ArrayList<Number> values = new ArrayList<Number>();
                    for (Object e : resultSet) {
                        Object value = this.resolveValue(e, parameters[0]);
                        if (value == null) continue;
                        if (value instanceof Collection) {
                            values.addAll((Collection)value);
                            continue;
                        }
                        if (!(value instanceof Number)) continue;
                        values.add((Number)value);
                    }
                    if (values.size() == 1) {
                        meanValue = (Number)values.get(0);
                    } else if (values.size() > 1) {
                        values.sort((o1, o2) -> (int)(o1.doubleValue() - o2.doubleValue()));
                        meanValue = (Number)values.get(Math.round((float)values.size() / 2.0f) - 1);
                    }
                } else {
                    void var12_29;
                    void var9_12;
                    Integer accumulatedValue = 0;
                    Integer n = 0;
                    for (Object e : resultSet) {
                        void var10_19;
                        switch (meanKind) {
                            case "geometric": {
                                Number[] numberArray = this.accumulateFunction(accumulatedValue, new Object[]{this.resolveValue(e, parameters[0])}, (A, V) -> A.multiply((BigDecimal)V));
                                break;
                            }
                            case "harmonic": {
                                Number[] numberArray = this.accumulateFunction(accumulatedValue, new Object[]{this.resolveValue(e, parameters[0])}, (A, V) -> A.add(new BigDecimal(1).divide((BigDecimal)V, (int)SystemProperties.getInteger("hcjf.query.function.big.decimal.divide.scale"), RoundingMode.HALF_EVEN)));
                                break;
                            }
                            default: {
                                Number[] numberArray = this.accumulateFunction(accumulatedValue, new Object[]{this.resolveValue(e, parameters[0])}, (A, V) -> A.add((BigDecimal)V));
                            }
                        }
                        Double d = var9_12.doubleValue() + var10_19[0].doubleValue();
                        accumulatedValue = var10_19[1];
                    }
                    String string = meanKind;
                    int n2 = -1;
                    switch (string.hashCode()) {
                        case 1392051265: {
                            if (!string.equals(GEOMETRIC)) break;
                            boolean bl = false;
                            break;
                        }
                        case 124995117: {
                            if (!string.equals(HARMONIC)) break;
                            boolean bl = true;
                        }
                    }
                    switch (var12_29) {
                        case 0: {
                            meanValue = Math.pow(((Number)accumulatedValue).doubleValue(), 1.0 / var9_12.doubleValue());
                            break;
                        }
                        case 1: {
                            meanValue = var9_12.doubleValue() / ((Number)accumulatedValue).doubleValue();
                            break;
                        }
                        default: {
                            meanValue = ((Number)accumulatedValue).doubleValue() / var9_12.doubleValue();
                        }
                    }
                }
                if (group) {
                    ArrayList<JoinableMap> newResultSet = new ArrayList<JoinableMap>();
                    JoinableMap joinableMap = new JoinableMap(new HashMap<String, Object>(), alias);
                    joinableMap.put(alias, (Object)meanValue);
                    newResultSet.add(joinableMap);
                    result = newResultSet;
                }
                for (Object e : resultSet) {
                    ((Map)e).put(alias, meanValue);
                }
            }
            catch (Exception ex) {
                throw new HCJFRuntimeException("Mean aggregate function fail", (Throwable)ex, new Object[0]);
            }
        } else {
            throw new HCJFRuntimeException("Mean aggregate function need at leas two parameter", new Object[0]);
        }
        return result;
    }
}

