/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.functions;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BiFunction;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.properties.SystemProperties;

public interface NumberSetFunction {
    default public Number[] accumulateFunction(Number accumulatedValue, Object[] parameters, BiFunction<BigDecimal, BigDecimal, Number> function) {
        Integer counter = 0;
        for (Object numericParameter : parameters) {
            if (numericParameter instanceof Collection) {
                for (Number collectionNumber : (Collection)numericParameter) {
                    accumulatedValue = this.applyFunction(accumulatedValue, collectionNumber, function);
                    Integer n = counter;
                    counter = counter + 1;
                }
                continue;
            }
            accumulatedValue = this.applyFunction(accumulatedValue, (Number)numericParameter, function);
            Integer n = counter;
            counter = counter + 1;
        }
        return new Number[]{counter, accumulatedValue};
    }

    default public Number applyFunction(Number firstNumber, Number secondNumber, BiFunction<BigDecimal, BigDecimal, Number> function) {
        Number result = function.apply(new BigDecimal(firstNumber.doubleValue()), new BigDecimal(secondNumber.doubleValue()));
        Boolean round = SystemProperties.getBoolean("hcjf.query.function.math.operation.result.round");
        if (result instanceof BigDecimal && round.booleanValue()) {
            Integer mathContext = SystemProperties.getInteger("hcjf.query.function.math.operation.result.round.context");
            switch (mathContext) {
                case 32: {
                    result = ((BigDecimal)result).round(MathContext.DECIMAL32);
                    break;
                }
                case 64: {
                    result = ((BigDecimal)result).round(MathContext.DECIMAL64);
                    break;
                }
                case 128: {
                    result = ((BigDecimal)result).round(MathContext.DECIMAL128);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public Object evalExpression(Object ... parameters) {
        void var2_19;
        Number evalResult = 0;
        Object firstValue = null;
        String comparator = null;
        String currentOperation = SystemProperties.get("hcjf.query.function.math.addition");
        for (Object parameter : parameters) {
            if (parameter instanceof String) {
                currentOperation = (String)parameter;
                if (!currentOperation.equals(SystemProperties.get("hcjf.query.function.maht.equals")) && !currentOperation.equals(SystemProperties.get("hcjf.query.function.math.distinct")) && !currentOperation.equals(SystemProperties.get("hcjf.query.function.math.distinct.2")) && !currentOperation.equals(SystemProperties.get("hcjf.query.function.math.grater.than")) && !currentOperation.equals(SystemProperties.get("hcjf.query.function.math.grater.than.or.equals")) && !currentOperation.equals(SystemProperties.get("hcjf.query.function.math.less.than")) && !currentOperation.equals(SystemProperties.get("hcjf.query.function.math.less.than.or.equals"))) continue;
                comparator = currentOperation;
                currentOperation = SystemProperties.get("hcjf.query.function.math.addition");
                firstValue = evalResult;
                evalResult = 0;
                continue;
            }
            if (!(parameter instanceof Number)) throw new HCJFRuntimeException("Illegal argument into the math expression: %s", Objects.toString(parameter));
            Number secondParameter = (Number)parameter;
            if (currentOperation.equals(SystemProperties.get("hcjf.query.function.math.addition"))) {
                evalResult = this.applyFunction(evalResult, secondParameter, BigDecimal::add);
                continue;
            }
            if (currentOperation.equals(SystemProperties.get("hcjf.query.function.math.subtraction"))) {
                evalResult = this.applyFunction(evalResult, secondParameter, BigDecimal::subtract);
                continue;
            }
            if (currentOperation.equals(SystemProperties.get("hcjf.query.function.math.multiplication"))) {
                evalResult = this.applyFunction(evalResult, secondParameter, BigDecimal::multiply);
                continue;
            }
            if (currentOperation.equals(SystemProperties.get("hcjf.query.function.math.division"))) {
                evalResult = this.applyFunction(evalResult, secondParameter, (bigDecimal, bigDecimal2) -> bigDecimal.divide((BigDecimal)bigDecimal2, (int)SystemProperties.getInteger("hcjf.query.function.big.decimal.divide.scale"), RoundingMode.HALF_EVEN));
                continue;
            }
            if (!currentOperation.equals(SystemProperties.get("hcjf.query.function.math.modulus"))) continue;
            evalResult = this.applyFunction(evalResult, secondParameter, BigDecimal::remainder);
        }
        if (comparator != null) {
            if (comparator.equals(SystemProperties.get("hcjf.query.function.maht.equals"))) {
                Boolean bl = firstValue.equals(evalResult);
                return var2_19;
            } else if (comparator.equals(SystemProperties.get("hcjf.query.function.math.distinct"))) {
                Boolean bl = !firstValue.equals(evalResult);
                return var2_19;
            } else if (comparator.equals(SystemProperties.get("hcjf.query.function.math.distinct.2"))) {
                Boolean bl = !firstValue.equals(evalResult);
                return var2_19;
            } else if (comparator.equals(SystemProperties.get("hcjf.query.function.math.grater.than"))) {
                Boolean bl = ((Number)firstValue).doubleValue() > evalResult.doubleValue();
                return var2_19;
            } else if (comparator.equals(SystemProperties.get("hcjf.query.function.math.grater.than.or.equals"))) {
                Boolean bl = ((Number)firstValue).doubleValue() >= evalResult.doubleValue();
                return var2_19;
            } else if (comparator.equals(SystemProperties.get("hcjf.query.function.math.less.than"))) {
                Boolean bl = ((Number)firstValue).doubleValue() < evalResult.doubleValue();
                return var2_19;
            } else {
                if (!comparator.equals(SystemProperties.get("hcjf.query.function.math.less.than.or.equals"))) throw new HCJFRuntimeException("Illegal comparator into the meth expression: %s", Objects.toString(comparator));
                Boolean bl = ((Number)firstValue).doubleValue() <= evalResult.doubleValue();
            }
            return var2_19;
        } else {
            Integer n = evalResult;
        }
        return var2_19;
    }

    default public Class getBiggerClass(Number firstNumber, Number secondNumber) {
        Class result = firstNumber instanceof Double || secondNumber instanceof Double ? Double.class : (firstNumber instanceof Float || secondNumber instanceof Float ? Float.class : (firstNumber instanceof Long || secondNumber instanceof Long ? Long.class : (firstNumber instanceof Integer || secondNumber instanceof Integer ? Integer.class : (firstNumber instanceof Short || secondNumber instanceof Short ? Short.class : (firstNumber instanceof Byte || secondNumber instanceof Byte ? Byte.class : Double.class)))));
        return result;
    }
}

