/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.model;

import java.util.Iterator;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.layers.query.JoinableMap;
import org.hcjf.layers.query.Query;
import org.hcjf.layers.query.model.QueryParameter;
import org.hcjf.layers.query.model.QueryResource;
import org.hcjf.utils.Introspection;

public class QueryField
extends QueryParameter {
    private boolean environmentIntrospection;

    public QueryField(Query query, String fieldPath) {
        super(query, fieldPath, fieldPath.startsWith("$") ? fieldPath.substring("$".length()) : fieldPath);
        if (fieldPath.contains(" ")) {
            throw new HCJFRuntimeException("Query field can\u00b4t contains white space: %s", fieldPath);
        }
        if (fieldPath.startsWith("$")) {
            this.environmentIntrospection = true;
        }
    }

    public <R> R resolve(Object instance) {
        R result = null;
        if (this.environmentIntrospection) {
            if (this.getContainer().getEnvironment() != null) {
                result = (R)Introspection.silentResolve(this.getContainer().getEnvironment(), this.getFieldPath());
            }
        } else if (instance instanceof JoinableMap && ((JoinableMap)instance).getResources().size() > 1) {
            if (this.getResource().equals(QueryResource.ANY)) {
                String resourceName;
                Iterator<String> iterator = ((JoinableMap)instance).getResources().iterator();
                while (iterator.hasNext() && (result = (R)Introspection.silentResolve(((JoinableMap)instance).getResourceModel(resourceName = iterator.next()), this.getFieldPath())) == null) {
                }
                if (result == null) {
                    result = (R)Introspection.silentResolve(instance, this.getFieldPath());
                }
            } else {
                result = (R)Introspection.silentResolve(((JoinableMap)instance).getResourceModel(this.getResource().getResourceName()), this.getFieldPath());
            }
        } else {
            result = (R)Introspection.silentResolve(instance, this.getFieldPath());
        }
        return result;
    }

    @Override
    public boolean verifyResource(QueryResource resource) {
        return this.getResource().equals(resource);
    }
}

