/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.scripting;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import jdk.jshell.JShell;
import jdk.jshell.Snippet;
import jdk.jshell.SnippetEvent;
import org.hcjf.bson.BsonCollection;
import org.hcjf.bson.BsonDecoder;
import org.hcjf.bson.BsonDocument;
import org.hcjf.bson.BsonEncoder;
import org.hcjf.errors.HCJFServiceTimeoutException;
import org.hcjf.layers.Layer;
import org.hcjf.layers.scripting.CodeEvaluator;
import org.hcjf.layers.scripting.ExecutionResult;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.Service;
import org.hcjf.service.ServiceSession;
import org.hcjf.utils.LruMap;
import org.hcjf.utils.Strings;

public class JavaCodeEvaluator
extends Layer
implements CodeEvaluator {
    private static final String CLASS_PATH_PROPERTY = "java.class.path";
    private static final String[] IMPORTS = new String[]{"java.util.*", "org.hcjf.utils.*", "org.hcjf.bson.*"};
    private static final String IMPORT_TEMPLATE = "import %s;";
    private static final String METHOD_WRAPPER = "public Object method_%s(Map<String,Object> parameters) throws Exception {%s}";
    private static final String CREATE_PARAMETERS = "Map<String,Object> var_%s = BsonDecoder.decode(Strings.hexToBytes(bson)).toMap();";
    private static final String CALL_METHOD = "var_%s.put(\"_result\", method_%s(var_%s));";
    private static final String CREATE_BSON_RESULT = "return Strings.bytesToHex(BsonEncoder.encode(new BsonDocument(var_%s)));";
    private static final String CREATE_RESULT_METHOD = "public String createResult_%s(String bson) throws Exception {%s\r\n%s\r\n%s\r\n}";
    private static final String CALL_RESULT_METHOD = "System.out.print(\">>>>\" + createResult_%s(\"%s\"));";
    private static final String RESULT = "_result";
    private static final String BSON_POINTER = ">>>>";
    private static final String OUT_FIELD = "_out";
    private static final String ERR_FIELD = "_error";
    private static final String DIAGNOSTICS_FIELD = "_diagnostics";
    private static final String START_DIAGNOSTIC_ERROR = "-->";
    private static final String END_DIAGNOSTIC_ERROR = "<--";
    private static final String WAITING_VM_TIME_FIELD = "_waitingVmTime";
    private static final String EVAL_TIME_FIELD = "_evalTime";
    private final Queue<JShellInstance> pool = new LinkedList<JShellInstance>();

    public JavaCodeEvaluator() {
        Integer size = SystemProperties.getInteger("hcjf.code.evaluator.java.j.shell.pool.size");
        for (int i = 0; i < size; ++i) {
            this.pool.offer(new JShellInstance());
        }
    }

    @Override
    public String getImplName() {
        return SystemProperties.get("hcjf.code.evaluator.java.impl.name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult evaluate(String script, Map<String, Object> parameters) {
        JShellInstance jShellInstance;
        Long waitingVmTime = System.currentTimeMillis();
        Queue<JShellInstance> queue = this.pool;
        synchronized (queue) {
            while (this.pool.isEmpty()) {
                try {
                    this.pool.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            jShellInstance = this.pool.remove();
            waitingVmTime = System.currentTimeMillis() - waitingVmTime;
        }
        Boolean killShell = false;
        Long timeout = SystemProperties.getLong("hcjf.code.evaluator.java.j.shell.instance.timeout");
        try {
            ExecutionResult result = Service.call(() -> jShellInstance.evaluate(script, parameters), ServiceSession.getCurrentIdentity(), timeout);
            result.getResultState().put(WAITING_VM_TIME_FIELD, waitingVmTime);
            ExecutionResult executionResult = result;
            return executionResult;
        }
        catch (HCJFServiceTimeoutException ex) {
            killShell = true;
            throw ex;
        }
        finally {
            Queue<JShellInstance> queue2 = this.pool;
            synchronized (queue2) {
                if (killShell.booleanValue()) {
                    jShellInstance.kill();
                    this.pool.offer(new JShellInstance());
                } else {
                    this.pool.offer(jShellInstance);
                }
                this.pool.notifyAll();
            }
        }
    }

    private static class JShellInstance
    implements LruMap.RemoveOverflowListener {
        private JShell jShell;
        private ByteArrayOutputStream outStream;
        private ByteArrayOutputStream errorStream;
        private PrintStream out;
        private PrintStream error;
        private LruMap<String, JShellScript> scriptCache;

        public JShellInstance() {
            this.init();
        }

        public void init() {
            this.outStream = new ByteArrayOutputStream();
            this.out = new PrintStream(this.outStream);
            this.errorStream = new ByteArrayOutputStream();
            this.error = new PrintStream(this.errorStream);
            this.jShell = JShell.builder().out(this.out).err(this.error).build();
            this.jShell.addToClasspath(System.getProperty(JavaCodeEvaluator.CLASS_PATH_PROPERTY));
            for (String i : IMPORTS) {
                this.jShell.eval(String.format(JavaCodeEvaluator.IMPORT_TEMPLATE, i));
            }
            List<String> customImports = SystemProperties.getList("hcjf.code.evaluator.java.script.cache.imports");
            for (String i : customImports) {
                this.jShell.eval(String.format(JavaCodeEvaluator.IMPORT_TEMPLATE, i));
            }
            this.scriptCache = new LruMap(SystemProperties.getInteger("hcjf.code.evaluator.java.script.cache.size"));
        }

        private List<SnippetEvent> createMethod(String scriptId, String script) {
            String method = String.format(JavaCodeEvaluator.METHOD_WRAPPER, scriptId, script);
            return this.jShell.eval(method);
        }

        private List<SnippetEvent> createResultMethod(String scriptId) {
            String resultMethod = String.format(JavaCodeEvaluator.CREATE_RESULT_METHOD, scriptId, String.format(JavaCodeEvaluator.CREATE_PARAMETERS, scriptId), String.format(JavaCodeEvaluator.CALL_METHOD, scriptId, scriptId, scriptId), String.format(JavaCodeEvaluator.CREATE_BSON_RESULT, scriptId));
            return this.jShell.eval(resultMethod);
        }

        private List<SnippetEvent> call(String scriptId, String bson) {
            String call = String.format(JavaCodeEvaluator.CALL_RESULT_METHOD, scriptId, bson);
            return this.jShell.eval(call);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ExecutionResult evaluate(String script, Map<String, Object> parameters) {
            Boolean fail = false;
            Long time = System.currentTimeMillis();
            String bson = Strings.bytesToHex(BsonEncoder.encode((BsonCollection)new BsonDocument(parameters)));
            ArrayList diagnosticsList = new ArrayList();
            try {
                ExecutionResult executionResult;
                String scriptId;
                JShellScript jShellScript = this.scriptCache.get(script);
                ArrayList<SnippetEvent> scriptSnippets = new ArrayList<SnippetEvent>();
                if (jShellScript == null) {
                    scriptId = UUID.randomUUID().toString().replace("-", "_");
                    scriptSnippets.addAll(this.createMethod(scriptId, script));
                    for (SnippetEvent snippetEvent : scriptSnippets) {
                        if (snippetEvent.status().equals((Object)Snippet.Status.VALID)) continue;
                        fail = true;
                        this.jShell.diagnostics(snippetEvent.snippet()).forEach(D -> {
                            StringBuilder sourceBuilder = new StringBuilder();
                            scriptSnippets.forEach(S -> sourceBuilder.append(S.snippet().source()));
                            StringBuilder builder = new StringBuilder();
                            String source = sourceBuilder.toString();
                            builder.append("\r\n");
                            builder.append("\r\n");
                            builder.append(snippetEvent.status().toString());
                            builder.append("\r\n");
                            builder.append(D.getMessage(Locale.getDefault()));
                            builder.append("\r\n");
                            builder.append(source, 0, (int)D.getStartPosition());
                            builder.append(JavaCodeEvaluator.START_DIAGNOSTIC_ERROR);
                            builder.append(source, (int)D.getStartPosition(), (int)D.getEndPosition());
                            builder.append(JavaCodeEvaluator.END_DIAGNOSTIC_ERROR);
                            builder.append(source.substring((int)D.getEndPosition()));
                            diagnosticsList.add(builder.toString());
                        });
                    }
                    if (!fail.booleanValue()) {
                        scriptSnippets.addAll(this.createResultMethod(scriptId));
                        this.scriptCache.put(script, new JShellScript(scriptId, script, scriptSnippets));
                    }
                } else {
                    scriptId = jShellScript.getId();
                }
                HashMap<String, Object> resultParameters = new HashMap<String, Object>();
                HashMap<String, Object> resultState = new HashMap<String, Object>();
                if (!fail.booleanValue()) {
                    this.call(scriptId, bson);
                    String bsonResult = this.outStream.toString();
                    Integer lastIndex = bsonResult.lastIndexOf(JavaCodeEvaluator.BSON_POINTER);
                    bsonResult = bsonResult.substring(lastIndex + JavaCodeEvaluator.BSON_POINTER.length());
                    resultParameters.putAll(BsonDecoder.decode((byte[])Strings.hexToBytes(bsonResult)).toMap());
                }
                resultState.put(JavaCodeEvaluator.OUT_FIELD, this.outStream.toString());
                resultState.put(JavaCodeEvaluator.ERR_FIELD, this.errorStream.toString());
                resultState.put(JavaCodeEvaluator.DIAGNOSTICS_FIELD, diagnosticsList);
                resultState.put(JavaCodeEvaluator.EVAL_TIME_FIELD, System.currentTimeMillis() - time);
                ExecutionResult executionResult2 = executionResult = new ExecutionResult(fail != false ? ExecutionResult.State.FAIL : ExecutionResult.State.SUCCESS, resultState, resultParameters, resultParameters.remove(JavaCodeEvaluator.RESULT));
                return executionResult2;
            }
            finally {
                this.outStream.reset();
                this.errorStream.reset();
            }
        }

        public synchronized void onRemove(Object key, Object value) {
            JShellScript jShellScript = (JShellScript)value;
            jShellScript.getSnippetEvents().forEach(E -> this.jShell.drop(E.snippet()));
        }

        public void kill() {
            this.jShell.close();
        }
    }

    private static class JShellScript {
        private final String id;
        private final String script;
        private final List<SnippetEvent> snippetEvents;

        public JShellScript(String id, String script, List<SnippetEvent> snippetEvents) {
            this.id = id;
            this.script = script;
            this.snippetEvents = snippetEvents;
        }

        public String getId() {
            return this.id;
        }

        public String getScript() {
            return this.script;
        }

        public List<SnippetEvent> getSnippetEvents() {
            return this.snippetEvents;
        }
    }
}

