/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.service.security;

import java.security.Permission;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hcjf.service.security.Grants;

public class SecurityPermissions {
    private static final String ID_CONCAT = "@";
    private static final Map<String, SecurityPermission> permissions = new HashMap<String, SecurityPermission>();

    private static String createPermissionId(String className, String permissionName) {
        return className + ID_CONCAT + permissionName;
    }

    public static SecurityPermission publishPermission(Class targetClass, String permissionName, String title, String description, List<String> tags) {
        return SecurityPermissions.createPermission(targetClass.getName(), permissionName, title, description, tags);
    }

    private static SecurityPermission createPermission(String className, String permissionName, String title, String description, List<String> tags) {
        String permissionId = SecurityPermissions.createPermissionId(className, permissionName);
        SecurityPermission permission = new SecurityPermission(permissionId, className, title, permissionName, description, tags);
        permissions.put(permissionId, permission);
        Grants.publishGrant(permission);
        return permission;
    }

    public static void checkPermission(Class targetClass, String permissionName) {
        System.getSecurityManager().checkPermission(SecurityPermissions.getPermission(targetClass.getName(), permissionName));
    }

    public static void checkPermission(Class targetClass, String permissionName, GrantedAction action) {
        try {
            System.getSecurityManager().checkPermission(SecurityPermissions.getPermission(targetClass.getName(), permissionName));
            action.onAction();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static SecurityPermission getPermission(String className, String permissionName) {
        return permissions.get(SecurityPermissions.createPermissionId(className, permissionName));
    }

    public static final class SecurityPermission
    extends Permission {
        private final String targetClassName;
        private final String permissionName;
        private final String title;
        private final String description;
        private final List<String> tags;

        private SecurityPermission(String name, String targetClassName, String permissionName, String title, String description, List<String> tags) {
            super(name);
            this.targetClassName = targetClassName;
            this.permissionName = permissionName;
            this.title = title;
            this.description = description;
            this.tags = tags;
        }

        public String getTargetClassName() {
            return this.targetClassName;
        }

        public String getPermissionName() {
            return this.permissionName;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getTags() {
            return this.tags;
        }

        @Override
        public boolean implies(Permission permission) {
            return false;
        }

        @Override
        public boolean equals(Object obj) {
            boolean result = false;
            if (obj instanceof SecurityPermission) {
                result = this.getName().equals(((SecurityPermission)obj).getName());
            }
            return result;
        }

        @Override
        public int hashCode() {
            return this.getName().hashCode();
        }

        @Override
        public String getActions() {
            return null;
        }
    }

    public static interface GrantedAction {
        public void onAction();
    }
}

