/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.utils;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.hcjf.properties.SystemProperties;
import org.hcjf.utils.Strings;

public class Cryptography {
    private AlgorithmParameterSpec spec;
    private Cipher cipher;
    private byte[] iv;
    private byte[] aadData;
    private SecureRandom secureRandom;
    private String operationMode;
    private static final String TR_PATTERN = "%s/%s/%s";
    private SecretKey secretKey;
    private int tagBigLength;

    public Cryptography() {
        this(SystemProperties.get("hcjf.cryptography.key"), SystemProperties.getInteger("hcjf.cryptography.random.iv.size"), SystemProperties.get("hcjf.cryptography.aad"), SystemProperties.get("hcjf.cryptography.algorithm"), SystemProperties.get("hcjf.cryptography.operation.mode"), SystemProperties.get("hcjf.cryptography.padding.scheme"), SystemProperties.getInteger("hcjf.cryptography.gcm.tag.bit.length"));
    }

    public Cryptography(String key, int ivSize, String aad, String algorithm, String operationMode, String paddingScheme, int tagBigLength) {
        this.iv = new byte[ivSize];
        this.aadData = aad.getBytes();
        this.secureRandom = new SecureRandom();
        this.tagBigLength = tagBigLength;
        this.secretKey = new SecretKeySpec(Strings.hexToBytes(key), "AES");
        String transformation = String.format(TR_PATTERN, algorithm, operationMode, paddingScheme);
        this.operationMode = operationMode;
        try {
            this.cipher = Cipher.getInstance(transformation);
        }
        catch (NoSuchAlgorithmException noSuchAlgoExc) {
            System.out.println("Exception while encrypting. Algorithm being requested is not available in this environment " + String.valueOf(noSuchAlgoExc));
        }
        catch (NoSuchPaddingException noSuchPaddingExc) {
            System.out.println("Exception while encrypting. Padding Scheme being requested is not available this environment " + String.valueOf(noSuchPaddingExc));
        }
    }

    public byte[] encrypt(byte[] message) {
        this.secureRandom.nextBytes(this.iv);
        this.initParameterSpec();
        byte[] encryptedMessage = this.convert(1, message);
        byte[] result = new byte[encryptedMessage.length + this.iv.length];
        System.arraycopy(this.iv, 0, result, 0, this.iv.length);
        System.arraycopy(encryptedMessage, 0, result, this.iv.length, encryptedMessage.length);
        return result;
    }

    public byte[] decrypt(byte[] message) {
        byte[] messageFragment = new byte[message.length - this.iv.length];
        System.arraycopy(message, 0, this.iv, 0, this.iv.length);
        System.arraycopy(message, this.iv.length, messageFragment, 0, messageFragment.length);
        this.initParameterSpec();
        return this.convert(2, messageFragment);
    }

    private void initParameterSpec() {
        if (this.operationMode.equals("GCM")) {
            this.spec = new GCMParameterSpec(this.tagBigLength, this.iv);
        }
    }

    private byte[] convert(int encryptMode, byte[] message) {
        byte[] result = null;
        try {
            this.cipher.init(encryptMode, (Key)this.secretKey, this.spec, new SecureRandom());
        }
        catch (InvalidKeyException invalidKeyExc) {
            System.out.println("Exception while encrypting. Key being used is not valid. It could be due to invalid encoding, wrong length or uninitialized " + String.valueOf(invalidKeyExc));
        }
        catch (InvalidAlgorithmParameterException invalidAlgoParamExc) {
            System.out.println("Exception while encrypting. Algorithm parameters being specified are not valid " + String.valueOf(invalidAlgoParamExc));
        }
        try {
            this.cipher.updateAAD(this.aadData);
        }
        catch (IllegalArgumentException illegalArgumentExc) {
            System.out.println("Exception thrown while encrypting. Byte array might be null " + String.valueOf(illegalArgumentExc));
        }
        catch (IllegalStateException illegalStateExc) {
            System.out.println("Exception thrown while encrypting. CIpher is in an illegal state " + String.valueOf(illegalStateExc));
        }
        catch (UnsupportedOperationException unsupportedExc) {
            System.out.println("Exception thrown while encrypting. Provider might not be supporting this method " + String.valueOf(unsupportedExc));
        }
        try {
            result = this.cipher.doFinal(message);
        }
        catch (IllegalBlockSizeException illegalBlockSizeExc) {
            System.out.println("Exception while encrypting, due to block size " + String.valueOf(illegalBlockSizeExc));
        }
        catch (BadPaddingException badPaddingExc) {
            System.out.println("Exception while encrypting, due to padding scheme " + String.valueOf(badPaddingExc));
        }
        return result;
    }

    public void setKey(byte[] key) {
        this.secretKey = new SecretKeySpec(key, "AES");
    }
}

