/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.utils;

import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCLineString;
import com.esri.core.geometry.ogc.OGCPoint;
import com.esri.core.geometry.ogc.OGCPolygon;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.utils.Introspection;
import org.hcjf.utils.JsonUtils;

public class GeoUtils {
    public static final OGCGeometry createGeometry(Object object) {
        OGCGeometry geometry;
        if (object instanceof byte[]) {
            geometry = OGCGeometry.fromBinary((ByteBuffer)ByteBuffer.wrap((byte[])object));
        } else if (object instanceof String) {
            geometry = ((String)object).startsWith("{") || ((String)object).startsWith("[") ? GeoUtils.fromGeoJson((Map)JsonUtils.createObject((String)object)) : OGCGeometry.fromText((String)((String)object));
        } else if (object instanceof Map) {
            geometry = GeoUtils.fromGeoJson((Map)object);
        } else {
            throw new HCJFRuntimeException("Illegal argument exception, unsupported geom data type: %s", object.getClass());
        }
        return geometry;
    }

    private static OGCGeometry fromGeoJson(Map<String, Object> geoJson) {
        OGCGeometry result = null;
        if (geoJson.containsKey("coordinates")) {
            result = OGCGeometry.fromGeoJson((String)JsonUtils.toJsonTree(geoJson).toString());
        } else {
            Collection features = (Collection)Introspection.resolve(geoJson, "features");
            for (Map feature : features) {
                Number buffer = (Number)Introspection.resolve((Object)feature, "properties._radius");
                if (buffer == null) {
                    buffer = (Number)Introspection.resolve((Object)feature, "properties._buffer");
                }
                OGCGeometry geometry = OGCGeometry.fromGeoJson((String)JsonUtils.toJsonTree(Introspection.resolve((Object)feature, "geometry")).toString());
                if (buffer != null) {
                    geometry = geometry.buffer(buffer.doubleValue());
                }
                if (result == null) {
                    result = geometry;
                    continue;
                }
                result.union(geometry);
            }
        }
        return result;
    }

    public static Double degreesToDouble(String value) {
        String[] parts = value.split("([\u00b0'\"])");
        String hour = parts[0];
        String minute = parts[1];
        String second = parts[2];
        String sign = parts[3].trim();
        double result = Double.parseDouble(hour) + Double.parseDouble(minute) / 60.0 + Double.parseDouble(second) / 3600.0;
        if (sign.equals("W") || sign.equals("O") || sign.equals("S")) {
            result *= -1.0;
        }
        return result;
    }

    public static Double calculatePerimeter(OGCPolygon ogcPolygon) {
        return GeoUtils.calculateLineDistance(ogcPolygon.exteriorRing());
    }

    public static Double calculateLineDistance(OGCLineString lineString) {
        Double distance = 0.0;
        Integer numberOfPoints = lineString.numPoints();
        for (int i = 0; i < numberOfPoints - 1; ++i) {
            OGCPoint startPoint = lineString.pointN(i);
            OGCPoint endPoint = lineString.pointN(i + 1);
            distance = distance + GeoUtils.calculateGeodesicDistance((OGCGeometry)startPoint, (OGCGeometry)endPoint);
        }
        return distance;
    }

    public static Double calculateArea(OGCPolygon ogcPolygon) {
        Polygon polygon = (Polygon)ogcPolygon.getEsriGeometry().copy();
        for (int i = 0; i < polygon.getPointCount(); ++i) {
            Point2D point = polygon.getXY(i);
            double[] xy = GeoUtils.wgs84ToGoogle(point.x, point.y);
            polygon.setXY(i, xy[0], xy[1]);
        }
        return polygon.calculateArea2D();
    }

    public static Double calculateGeodesicDistance(OGCGeometry geometry1, OGCGeometry geometry2) {
        return GeometryEngine.geodesicDistanceOnWGS84((Point)((Point)geometry1.centroid().getEsriGeometry()), (Point)((Point)geometry2.centroid().getEsriGeometry()));
    }

    private static double[] wgs84ToGoogle(double lon, double lat) {
        double x = lon * 2.003750834E7 / 180.0;
        double y = Math.log(Math.tan((90.0 + lat) * Math.PI / 360.0)) / (Math.PI / 180);
        y = y * 2.003750834E7 / 180.0;
        return new double[]{x, y};
    }

    private static double[] googleToWgs84(double x, double y) {
        double lon = x / 2.003750834E7 * 180.0;
        double lat = y / 2.003750834E7 * 180.0;
        lat = 57.29577951308232 * (2.0 * Math.atan(Math.exp(lat * Math.PI / 180.0)) - 1.5707963267948966);
        return new double[]{lon, lat};
    }

    public static void main(String[] args) {
    }

    private static final class Paths {
        private static final String COORDINATES = "coordinates";
        private static final String FEATURES = "features";
        private static final String PROPERTIES_RADIUS = "properties._radius";
        private static final String PROPERTIES_BUFFER = "properties._buffer";
        private static final String GEOMETRY = "geometry";

        private Paths() {
        }
    }
}

