/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.utils;

public final class SynchronizedCountOperation {
    private static final Operation meanOperation = new Mean();
    private static final Operation harmonicMeanOperation = new HarmonicMean();
    private final int maxCount;
    private final long maxTime;
    private final Operation operation;
    private int counter;
    private long lastExecution;
    private double accumulator;
    private double currentValue;

    public SynchronizedCountOperation(Operation operation, int maxCount, long maxTime) {
        this.operation = operation;
        this.maxCount = maxCount;
        this.maxTime = maxTime;
    }

    public SynchronizedCountOperation(Operation operation, int maxCount) {
        this(operation, maxCount, Long.MAX_VALUE);
    }

    public SynchronizedCountOperation(Operation operation, long maxTime) {
        this(operation, Integer.MAX_VALUE, maxTime);
    }

    public synchronized void add(double value) {
        ++this.counter;
        this.accumulator = this.operation.accumulate(this.accumulator, value);
        if (this.counter >= this.maxCount || System.currentTimeMillis() - this.lastExecution > this.maxTime) {
            this.currentValue = this.operation.execute(this.currentValue, this.accumulator, this.counter, this.lastExecution);
            this.counter = 0;
            this.accumulator = 0.0;
            this.lastExecution = System.currentTimeMillis();
        }
    }

    public double getCurrentValue() {
        return this.currentValue;
    }

    public static Operation getMeanOperation() {
        return meanOperation;
    }

    public static Operation getHarmonicMeanOperation() {
        return harmonicMeanOperation;
    }

    public static interface Operation {
        public double accumulate(double var1, double var3);

        public double execute(double var1, double var3, int var5, long var6);
    }

    private static class Mean
    implements Operation {
        private Mean() {
        }

        @Override
        public double accumulate(double accumulator, double value) {
            return accumulator + value;
        }

        @Override
        public double execute(double currentValue, double accumulator, int counter, long lastExecution) {
            return currentValue == 0.0 ? accumulator / (double)counter : (accumulator / (double)counter + currentValue) / 2.0;
        }
    }

    private static class HarmonicMean
    implements Operation {
        private HarmonicMean() {
        }

        @Override
        public double accumulate(double accumulator, double value) {
            return accumulator + (value == 0.0 ? 0.0 : 1.0 / value);
        }

        @Override
        public double execute(double currentValue, double accumulator, int counter, long lastExecution) {
            return currentValue == 0.0 ? (double)counter / accumulator : ((double)counter / accumulator + currentValue) / 2.0;
        }
    }
}

