/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class TtlCollection<K> {
    private final Map<Long, K> timeWindows;
    private final Long timeWindowsSize;

    public TtlCollection(Long timeWindowsSize) {
        this.timeWindowsSize = timeWindowsSize;
        this.timeWindows = new HashMap<Long, K>();
    }

    protected final synchronized void addInstance(K instance) {
        this.timeWindows.put(System.currentTimeMillis(), (Long)instance);
    }

    protected final synchronized void removeOldWindows() {
        Long current = System.currentTimeMillis();
        Iterator<Long> iterator = this.timeWindows.keySet().iterator();
        while (iterator.hasNext()) {
            Long time = iterator.next();
            if (time + this.timeWindowsSize >= current) continue;
            this.removeOldInstance(this.timeWindows.get(time));
            iterator.remove();
        }
    }

    protected abstract void removeOldInstance(K var1);
}

