/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.infra.pressure;

import com.github.jbgust.jsrm.calculation.Formula;
import com.github.jbgust.jsrm.infra.FormulaConfiguration;
import com.github.jbgust.jsrm.infra.JSRMConstant;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;

public enum PostBurnPressureFormulas implements Formula
{
    POST_BURN_TIME_SINCE_BURN_STARTS(new FormulaConfiguration("POST_BURN_TIME_SINCE_BURN_STARTS_previous + tbinc").withConstants(JSRMConstant.tbinc).withVariables("POST_BURN_TIME_SINCE_BURN_STARTS_previous")),
    POST_BURN_CHAMBER_PRESSURE_MPA(new FormulaConfiguration("pbout*exp(-rat*to*astarf*(POST_BURN_TIME_SINCE_BURN_STARTS-tbout)/vc*1000000000/cstar)").withDependencies("POST_BURN_TIME_SINCE_BURN_STARTS").withConstants(JSRMConstant.pbout, JSRMConstant.rat, JSRMConstant.to, JSRMConstant.astarf, JSRMConstant.tbout, JSRMConstant.vc, JSRMConstant.cstar)),
    POST_BURN_ABSOLUTE_CHAMBER_PRESSURE(new FormulaConfiguration("POST_BURN_CHAMBER_PRESSURE_MPA-patm").withDependencies("POST_BURN_CHAMBER_PRESSURE_MPA").withConstants(JSRMConstant.patm)),
    POST_BURN_ABSOLUTE_CHAMBER_PRESSURE_PSIG(new FormulaConfiguration("POST_BURN_ABSOLUTE_CHAMBER_PRESSURE*1000000/6895").withDependencies("POST_BURN_ABSOLUTE_CHAMBER_PRESSURE"));

    private final Expression expression;
    private final Set<String> dependencies;
    private final String expressionAsString;

    private PostBurnPressureFormulas(FormulaConfiguration config) {
        this.expressionAsString = config.getFormula();
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.expressionAsString);
        this.dependencies = Stream.of(config.getDependencies()).peek(arg_0 -> ((ExpressionBuilder)expressionBuilder).variable(arg_0)).collect(Collectors.toSet());
        expressionBuilder.functions(config.getFunctions());
        Stream.of(config.getConstants()).map(Enum::toString).forEach(arg_0 -> ((ExpressionBuilder)expressionBuilder).variable(arg_0));
        Stream.of(config.getVariables()).forEach(arg_0 -> ((ExpressionBuilder)expressionBuilder).variable(arg_0));
        this.expression = expressionBuilder.build();
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getExpressionAsString() {
        return this.expressionAsString;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public Set<Formula> getDependencies() {
        return this.dependencies.stream().map(PostBurnPressureFormulas::valueOf).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getVariablesNames() {
        return this.expression.getVariableNames();
    }
}

