/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.application.result;

import net.objecthunter.exp4j.ExpressionBuilder;

public class Nozzle {
    private static final String CROSS_SECTION_DIAMETER_VAR = "crossSectionDiameter";
    private static final String ANGLE_VAR = "angle";
    private static final ExpressionBuilder nozzleLenghtExpression = new ExpressionBuilder("crossSectionDiameter / 2 / tan(angle * pi / 180)").variables(new String[]{"crossSectionDiameter", "angle"});
    private final double nozzleThroatDiameterInMillimeter;
    private final double chamberInsideDiameterInMillimeter;
    private final double optimalNozzleExpansionRatio;
    private final double optimalNozzleExitDiameterInMillimeter;
    private final double nozzleExpansionRatio;
    private final double nozzleExitDiameterInMillimeter;
    private final double initialNozzleExitSpeedInMach;
    private final double finalNozzleExitSpeedInMach;

    public Nozzle(double nozzleThroatDiameterInMillimeter, double chamberInsideDiameterInMillimeter, double optimalNozzleExpansionRatio, double optimalNozzleExitDiameterInMillimeter, double nozzleExpansionRatio, double nozzleExitDiameterInMillimeter, double initialNozzleExitSpeedInMach, double finalNozzleExitSpeedInMach) {
        this.nozzleThroatDiameterInMillimeter = nozzleThroatDiameterInMillimeter;
        this.chamberInsideDiameterInMillimeter = chamberInsideDiameterInMillimeter;
        this.optimalNozzleExpansionRatio = optimalNozzleExpansionRatio;
        this.optimalNozzleExitDiameterInMillimeter = optimalNozzleExitDiameterInMillimeter;
        this.nozzleExpansionRatio = nozzleExpansionRatio;
        this.nozzleExitDiameterInMillimeter = nozzleExitDiameterInMillimeter;
        this.initialNozzleExitSpeedInMach = initialNozzleExitSpeedInMach;
        this.finalNozzleExitSpeedInMach = finalNozzleExitSpeedInMach;
    }

    public double getNozzleThroatDiameterInMillimeter() {
        return this.nozzleThroatDiameterInMillimeter;
    }

    public double getChamberInsideDiameterInMillimeter() {
        return this.chamberInsideDiameterInMillimeter;
    }

    public double getOptimalNozzleExpansionRatio() {
        return this.optimalNozzleExpansionRatio;
    }

    public double getOptimalNozzleExitDiameterInMillimeter() {
        return this.optimalNozzleExitDiameterInMillimeter;
    }

    public double getNozzleExpansionRatio() {
        return this.nozzleExpansionRatio;
    }

    public double getNozzleExitDiameterInMillimeter() {
        return this.nozzleExitDiameterInMillimeter;
    }

    public double getInitialNozzleExitSpeedInMach() {
        return this.initialNozzleExitSpeedInMach;
    }

    public double getFinalNozzleExitSpeedInMach() {
        return this.finalNozzleExitSpeedInMach;
    }

    public double getConvergenceLenghtInMillimeter(double convergenceHalfAngleInDegree) {
        return this.getLength(convergenceHalfAngleInDegree, this.chamberInsideDiameterInMillimeter - this.nozzleThroatDiameterInMillimeter);
    }

    public double getDivergenceLenghtInMillimeter(double divergenceHalfAngleInDegree) {
        return this.getLength(divergenceHalfAngleInDegree, this.nozzleExitDiameterInMillimeter - this.nozzleThroatDiameterInMillimeter);
    }

    public double getOptimalDivergenceLenghtInMillimeter(double divergenceHalfAngleInDegree) {
        return this.getLength(divergenceHalfAngleInDegree, this.optimalNozzleExitDiameterInMillimeter - this.nozzleThroatDiameterInMillimeter);
    }

    private double getLength(double divergenceHalfAngleInDegree, double crossSectionDiameter) {
        return nozzleLenghtExpression.build().setVariable(CROSS_SECTION_DIAMETER_VAR, crossSectionDiameter).setVariable(ANGLE_VAR, divergenceHalfAngleInDegree).evaluate();
    }
}

