/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.calculation;

import com.github.jbgust.jsrm.application.exception.UnknownResultException;
import com.github.jbgust.jsrm.calculation.Formula;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CalculatorResults {
    private Map<Formula, List<Double>> results;
    private Set<Formula> resultsToSave;

    public CalculatorResults(Formula ... formulasToSave) {
        this.resultsToSave = Sets.newHashSet((Object[])formulasToSave);
        this.results = new HashMap<Formula, List<Double>>();
        this.resultsToSave.forEach(formula -> {
            List cfr_ignored_0 = this.results.put((Formula)formula, new ArrayList());
        });
    }

    public void addResult(Map<Formula, Double> lineResult) {
        lineResult.forEach(this::saveResult);
    }

    public Double getResult(Formula formula, int lineNumber) {
        this.checkResultExists(formula);
        return this.results.get(formula).get(lineNumber);
    }

    private void saveResult(Formula formula, Double result) {
        if (this.resultsToSave.contains(formula)) {
            this.results.get(formula).add(result);
        }
    }

    public List<Double> getResults(Formula formula) {
        this.checkResultExists(formula);
        return this.results.get(formula);
    }

    private void checkResultExists(Formula formula) throws UnknownResultException {
        if (!this.resultsToSave.contains(formula)) {
            throw new UnknownResultException(formula);
        }
    }
}

