/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.calculation;

import com.github.jbgust.jsrm.calculation.Formula;
import com.github.jbgust.jsrm.calculation.ResultLineProvider;
import com.github.jbgust.jsrm.calculation.exception.InvalidResultException;
import com.github.jbgust.jsrm.calculation.exception.LineCalculatorException;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class LineCalculator {
    private final Formula formula;
    private final Map<String, Double> constants;
    private final Map<Formula, Double> initialValues;
    private final Set<ResultLineProvider> resultLineProviders;
    private final Map<String, Double> previousLineResults;
    private Map<Formula, Double> currentLineResults;
    private Map<String, Double> currentLineProvidedResult;

    public LineCalculator(Formula formula, Map<String, Double> constants, Map<Formula, Double> initialValues) {
        this(formula, constants, initialValues, Collections.emptySet());
    }

    public LineCalculator(Formula formula, Map<String, Double> constants, Map<Formula, Double> initialValues, Set<ResultLineProvider> resultLineProviders) {
        this.formula = formula;
        this.initialValues = new HashMap<Formula, Double>(initialValues);
        this.resultLineProviders = resultLineProviders;
        this.previousLineResults = new HashMap<String, Double>();
        this.constants = constants;
    }

    public Map<Formula, Double> compute(int lineNumber) {
        this.currentLineResults = new HashMap<Formula, Double>();
        this.storeProvidedResults(lineNumber);
        this.run(this.formula, lineNumber);
        this.addPreviousValues();
        return this.currentLineResults;
    }

    private void storeProvidedResults(int lineNumber) {
        this.currentLineProvidedResult = this.resultLineProviders.stream().collect(Collectors.toMap(ResultLineProvider::getName, resultLineProvider -> resultLineProvider.getResult(lineNumber)));
    }

    private void addPreviousValues() {
        this.previousLineResults.clear();
        this.previousLineResults.putAll(this.currentLineResults.entrySet().stream().collect(Collectors.toMap(o -> ((Formula)o.getKey()).getName() + "_previous", Map.Entry::getValue)));
        this.previousLineResults.putAll(this.currentLineProvidedResult.entrySet().stream().collect(Collectors.toMap(o -> (String)o.getKey() + "_previous", Map.Entry::getValue)));
    }

    private void run(Formula formula, int lineNumber) {
        this.resolveVariablesDependencies(formula, lineNumber);
        if (this.hasInitialValue(formula)) {
            this.currentLineResults.put(formula, this.initialValues.remove(formula));
        } else {
            ImmutableMap variables = Collections.emptyMap();
            try {
                variables = new ImmutableMap.Builder().putAll(this.currentLineProvidedResult).putAll(this.getVariablesFromDependentCalculations(formula)).putAll(this.getPreviousVariables(formula)).putAll(this.constants).build();
                double result = formula.getExpression().setVariables((Map)variables).evaluate();
                if (Double.isNaN(result)) {
                    throw new InvalidResultException("The result is not a number");
                }
                this.currentLineResults.put(formula, result);
            }
            catch (Exception e) {
                Map<String, Double> variablesUsed = variables.entrySet().stream().filter(entry -> formula.getExpression().getVariableNames().contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                throw new LineCalculatorException(formula, variablesUsed, lineNumber, this.previousLineResults, this.currentLineResults, e);
            }
        }
    }

    private boolean hasInitialValue(Formula formula) {
        return this.initialValues.containsKey(formula);
    }

    private Map<String, Double> getPreviousVariables(Formula formula) {
        return this.previousLineResults.entrySet().stream().filter(previousResultEntry -> formula.getVariablesNames().contains(previousResultEntry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, Double> getVariablesFromDependentCalculations(Formula formula) {
        return this.currentLineResults.entrySet().stream().filter(entry -> formula.getDependencies().contains(entry.getKey())).collect(Collectors.toMap(entry -> ((Formula)entry.getKey()).getName(), Map.Entry::getValue));
    }

    private void resolveVariablesDependencies(Formula formula, int lineNumber) {
        formula.getDependencies().stream().filter(entry -> !this.currentLineResults.keySet().contains(entry)).forEach(currentFormula -> this.run((Formula)currentFormula, lineNumber));
    }
}

