/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.application.motor.grain;

import com.github.jbgust.jsrm.application.exception.InvalidMotorDesignException;
import com.github.jbgust.jsrm.application.motor.SolidRocketMotor;
import com.github.jbgust.jsrm.application.motor.grain.GrainSurface;
import com.github.jbgust.jsrm.application.motor.grain.core.BurningShape;
import com.github.jbgust.jsrm.application.motor.grain.core.ExtrudedShapeGrain;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class CSlotGrain
extends ExtrudedShapeGrain {
    private final double outerDiameter;
    private final double coreDiameter;
    private final double slotWidth;
    private final double slotDepth;
    private final double slotOffset;
    private final int numberOfSegment;

    public CSlotGrain(double outerDiameter, double coreDiameter, double slotWidth, double slotDepth, double slotOffset, int numberOfSegment, double length, GrainSurface endSurface) {
        this.outerDiameter = outerDiameter;
        this.coreDiameter = coreDiameter;
        this.slotWidth = slotWidth;
        this.slotDepth = slotDepth;
        this.slotOffset = slotOffset;
        this.numberOfSegment = numberOfSegment;
        this.setAftEndInhibited(endSurface);
        this.setForeEndInhibited(endSurface);
        this.setLength(length);
        this.generateGeometry();
    }

    private void generateGeometry() {
        double odmm = this.outerDiameter;
        double wmm = this.slotWidth;
        double dmm = this.slotDepth;
        this.xsection = new BurningShape();
        Ellipse2D.Double outside = new Ellipse2D.Double(0.0, 0.0, odmm, odmm);
        this.xsection.add(outside);
        this.xsection.inhibit(outside);
        double offmm = this.slotOffset;
        double ymm = odmm / 2.0 - wmm / 2.0 - offmm;
        double xmm = odmm - dmm;
        Rectangle2D.Double slot = new Rectangle2D.Double(xmm, ymm, dmm, wmm);
        this.xsection.subtract(slot);
        double idmm = this.coreDiameter;
        double idymm = odmm / 2.0 - idmm / 2.0 - offmm;
        double idxmm = xmm - idmm / 2.0;
        Ellipse2D.Double id = new Ellipse2D.Double(idxmm, idymm, idmm, idmm);
        this.xsection.subtract(id);
    }

    @Override
    public int getNumberOfSegments() {
        return this.numberOfSegment;
    }

    @Override
    public void checkConfiguration(SolidRocketMotor solidRocketMotor) throws InvalidMotorDesignException {
        if (this.coreDiameter < 0.0) {
            throw new InvalidMotorDesignException("Core diameter should be positive");
        }
        if (this.outerDiameter <= 0.0) {
            throw new InvalidMotorDesignException("Outer diameter should be > 0");
        }
        if (this.getLength() <= 0.0) {
            throw new InvalidMotorDesignException("Grain length should be > 0");
        }
        if (this.numberOfSegment <= 0) {
            throw new InvalidMotorDesignException("Number of segment should be > 0");
        }
        if (this.coreDiameter >= this.outerDiameter) {
            throw new InvalidMotorDesignException("Core diameter should be < than outer diameter");
        }
        if (this.getLength() * (double)this.getNumberOfSegments() > solidRocketMotor.getCombustionChamber().getChamberLengthInMillimeter()) {
            throw new InvalidMotorDesignException("Combustion chamber length should be >= than Grain total length");
        }
        if (this.outerDiameter > solidRocketMotor.getCombustionChamber().getChamberInnerDiameterInMillimeter()) {
            throw new InvalidMotorDesignException("Combution chamber diameter should be >= than grain outer diameter");
        }
        if (this.slotOffset < 0.0) {
            throw new InvalidMotorDesignException("Slot offset should be positive");
        }
        if (this.slotOffset >= this.outerDiameter / 2.0) {
            throw new InvalidMotorDesignException("Slot offset should be < than grain radius");
        }
        if (this.slotDepth <= 0.0) {
            throw new InvalidMotorDesignException("Slot depth should be > 0");
        }
        if (this.slotDepth >= this.outerDiameter) {
            throw new InvalidMotorDesignException("Slot depth should be <= than outer diameter");
        }
        if (this.slotWidth <= 0.0) {
            throw new InvalidMotorDesignException("Slot width should be > 0");
        }
        if (this.slotWidth >= this.outerDiameter) {
            throw new InvalidMotorDesignException("Slot width should be <= than outer diameter");
        }
    }
}

