/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.calculation;

import com.github.jbgust.jsrm.calculation.CalculatorResults;
import com.github.jbgust.jsrm.calculation.Formula;
import com.github.jbgust.jsrm.calculation.LineCalculator;
import com.github.jbgust.jsrm.calculation.ResultLineProvider;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;

public class Calculator {
    private final Formula formula;
    private final Map<String, Double> constants;
    private final Map<Formula, Double> initialValues;
    private final CalculatorResults calculatorResults;
    private final Set<ResultLineProvider> resultLineProviders;

    Calculator(Formula formula, Map<String, Double> constants, Map<Formula, Double> initialValues, Set<ResultLineProvider> resultLineProviders, Formula ... resultsToSave) {
        this.formula = formula;
        this.constants = constants;
        this.initialValues = initialValues;
        this.resultLineProviders = resultLineProviders;
        this.calculatorResults = new CalculatorResults(resultsToSave);
    }

    public CalculatorResults compute(int fromLine, int toLine) {
        LineCalculator lineCalculator = new LineCalculator(this.formula, this.constants, this.initialValues, this.resultLineProviders);
        IntStream.range(fromLine, toLine).mapToObj(lineCalculator::compute).forEach(this.calculatorResults::addResult);
        return this.calculatorResults;
    }
}

