/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.calculation.exception;

import com.github.jbgust.jsrm.calculation.Formula;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;

public class LineCalculatorException
extends RuntimeException {
    public LineCalculatorException(Formula formula, Map<String, Double> variables, int lineNumber, Map<String, Double> previousLineResults, Map<Formula, Double> currentLineResults, Exception exception) {
        super(String.format("Failed to compute %s in line %s:\nformula :\n\t%s\nvariables :\n\t%s\ncurrent line results :\n\t%s\nprevious line result :\n\t%s\n", formula.getName(), lineNumber, formula.getExpressionAsString(), LineCalculatorException.mapToString(variables), LineCalculatorException.currentResultToString(currentLineResults), LineCalculatorException.mapToString(previousLineResults)), exception);
    }

    private static String currentResultToString(Map<Formula, Double> currentLineResults) {
        return currentLineResults.entrySet().stream().sorted(Comparator.comparing(formulaDoubleEntry -> ((Formula)formulaDoubleEntry.getKey()).getName())).map(entry -> entry.getKey() + " = " + entry.getValue()).collect(Collectors.joining("\n\t"));
    }

    private static String mapToString(Map<String, Double> variables) {
        return variables.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(entry -> (String)entry.getKey() + " = " + entry.getValue()).collect(Collectors.joining("\n\t"));
    }
}

