/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.infra.performance;

import com.github.jbgust.jsrm.infra.performance.PerformanceCalculation;
import java.util.List;
import java.util.Map;

public final class PerformanceCalculationResult {
    private final Map<PerformanceCalculation.Results, List<Double>> results;
    private final double optimalNozzleExpansionResult;
    private final double initialNozzleExitSpeedInMach;
    private final double finalNozzleExitSpeedInMach;
    private final double optimalNozzleExitDiameterInMillimeter;
    private final double nozzleExitDiameterInMillimeter;

    public PerformanceCalculationResult(Map<PerformanceCalculation.Results, List<Double>> results, double optimalNozzleExpansionResult, double initialNozzleExitSpeedInMach, double finalNozzleExitSpeedInMach, double optimalNozzleExitDiameterInMillimeter, double nozzleExitDiameterInMillimeter) {
        this.results = results;
        this.optimalNozzleExpansionResult = optimalNozzleExpansionResult;
        this.initialNozzleExitSpeedInMach = initialNozzleExitSpeedInMach;
        this.finalNozzleExitSpeedInMach = finalNozzleExitSpeedInMach;
        this.optimalNozzleExitDiameterInMillimeter = optimalNozzleExitDiameterInMillimeter;
        this.nozzleExitDiameterInMillimeter = nozzleExitDiameterInMillimeter;
    }

    public Map<PerformanceCalculation.Results, List<Double>> getResults() {
        return this.results;
    }

    public double getOptimalNozzleExpansionResult() {
        return this.optimalNozzleExpansionResult;
    }

    public double getInitialNozzleExitSpeedInMach() {
        return this.initialNozzleExitSpeedInMach;
    }

    public double getFinalNozzleExitSpeedInMach() {
        return this.finalNozzleExitSpeedInMach;
    }

    public double getOptimalNozzleExitDiameterInMillimeter() {
        return this.optimalNozzleExitDiameterInMillimeter;
    }

    public double getNozzleExitDiameterInMillimeter() {
        return this.nozzleExitDiameterInMillimeter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PerformanceCalculationResult)) {
            return false;
        }
        PerformanceCalculationResult other = (PerformanceCalculationResult)o;
        if (Double.compare(this.getOptimalNozzleExpansionResult(), other.getOptimalNozzleExpansionResult()) != 0) {
            return false;
        }
        if (Double.compare(this.getInitialNozzleExitSpeedInMach(), other.getInitialNozzleExitSpeedInMach()) != 0) {
            return false;
        }
        if (Double.compare(this.getFinalNozzleExitSpeedInMach(), other.getFinalNozzleExitSpeedInMach()) != 0) {
            return false;
        }
        if (Double.compare(this.getOptimalNozzleExitDiameterInMillimeter(), other.getOptimalNozzleExitDiameterInMillimeter()) != 0) {
            return false;
        }
        if (Double.compare(this.getNozzleExitDiameterInMillimeter(), other.getNozzleExitDiameterInMillimeter()) != 0) {
            return false;
        }
        Map<PerformanceCalculation.Results, List<Double>> this$results = this.getResults();
        Map<PerformanceCalculation.Results, List<Double>> other$results = other.getResults();
        return !(this$results == null ? other$results != null : !((Object)this$results).equals(other$results));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $optimalNozzleExpansionResult = Double.doubleToLongBits(this.getOptimalNozzleExpansionResult());
        result = result * 59 + (int)($optimalNozzleExpansionResult >>> 32 ^ $optimalNozzleExpansionResult);
        long $initialNozzleExitSpeedInMach = Double.doubleToLongBits(this.getInitialNozzleExitSpeedInMach());
        result = result * 59 + (int)($initialNozzleExitSpeedInMach >>> 32 ^ $initialNozzleExitSpeedInMach);
        long $finalNozzleExitSpeedInMach = Double.doubleToLongBits(this.getFinalNozzleExitSpeedInMach());
        result = result * 59 + (int)($finalNozzleExitSpeedInMach >>> 32 ^ $finalNozzleExitSpeedInMach);
        long $optimalNozzleExitDiameterInMillimeter = Double.doubleToLongBits(this.getOptimalNozzleExitDiameterInMillimeter());
        result = result * 59 + (int)($optimalNozzleExitDiameterInMillimeter >>> 32 ^ $optimalNozzleExitDiameterInMillimeter);
        long $nozzleExitDiameterInMillimeter = Double.doubleToLongBits(this.getNozzleExitDiameterInMillimeter());
        result = result * 59 + (int)($nozzleExitDiameterInMillimeter >>> 32 ^ $nozzleExitDiameterInMillimeter);
        Map<PerformanceCalculation.Results, List<Double>> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        return result;
    }

    public String toString() {
        return "PerformanceCalculationResult(results=" + this.getResults() + ", optimalNozzleExpansionResult=" + this.getOptimalNozzleExpansionResult() + ", initialNozzleExitSpeedInMach=" + this.getInitialNozzleExitSpeedInMach() + ", finalNozzleExitSpeedInMach=" + this.getFinalNozzleExitSpeedInMach() + ", optimalNozzleExitDiameterInMillimeter=" + this.getOptimalNozzleExitDiameterInMillimeter() + ", nozzleExitDiameterInMillimeter=" + this.getNozzleExitDiameterInMillimeter() + ")";
    }
}

